/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidBaseProgramRunner
extends GenericProgramRunner {
    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        boolean isSwap;
        boolean showRunContent = env.getRunProfile() instanceof AndroidTestRunConfiguration;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        boolean bl = isSwap = (Boolean)MoreObjects.firstNonNull((Object)env.getCopyableUserData(CodeSwapAction.KEY), (Object)Boolean.FALSE) != false || (Boolean)MoreObjects.firstNonNull((Object)env.getCopyableUserData(ApplyChangesAction.KEY), (Object)Boolean.FALSE) != false;
        if (runnerAndConfigurationSettings != null) {
            runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(!isSwap && showRunContent);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult result2 = state.execute(env.getExecutor(), (ProgramRunner)this);
        RunContentDescriptor descriptor2 = null;
        if (isSwap && result2 != null) {
            RunContentManager manager = RunContentManager.getInstance((Project)env.getProject());
            descriptor2 = manager.findContentDescriptor(env.getExecutor(), result2.getProcessHandler());
        }
        if (descriptor2 == null || descriptor2.getAttachedContent() == null) {
            descriptor2 = DefaultProgramRunnerKt.showRunContent((ExecutionResult)result2, (ExecutionEnvironment)env);
        } else if (!(descriptor2 instanceof HiddenRunContentDescriptor)) {
            Content content = descriptor2.getAttachedContent();
            descriptor2 = new HiddenRunContentDescriptor(descriptor2);
            content.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor2);
        }
        if (descriptor2 != null) {
            if (isSwap) {
                descriptor2.setActivateToolWindowWhenAdded(false);
            }
            ProcessHandler processHandler = descriptor2.getProcessHandler();
            assert (processHandler != null);
            RunProfile runProfile = env.getRunProfile();
            int uniqueId = runProfile instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
            AndroidSessionInfo sessionInfo = new AndroidSessionInfo(processHandler, descriptor2, uniqueId, env.getExecutor().getId(), env.getExecutor().getActionName(), env.getExecutionTarget());
            processHandler.putUserData(AndroidSessionInfo.KEY, (Object)sessionInfo);
        }
        return descriptor2;
    }

    @VisibleForTesting
    static class HiddenRunContentDescriptor
    extends RunContentDescriptor {
        @NotNull
        private final RunContentDescriptor myDelegate;

        private HiddenRunContentDescriptor(@NotNull RunContentDescriptor delegate) {
            super(null, null, (JComponent)new JLabel(), "hidden", null, null, null);
            this.myDelegate = delegate;
            Disposer.register((Disposable)this, (Disposable)this.myDelegate);
        }

        public Runnable getActivationCallback() {
            return this.myDelegate.getActivationCallback();
        }

        @NotNull
        public AnAction[] getRestartActions() {
            return this.myDelegate.getRestartActions();
        }

        public ExecutionConsole getExecutionConsole() {
            return this.myDelegate.getExecutionConsole();
        }

        public void dispose() {
        }

        @Nullable
        public Icon getIcon() {
            return this.myDelegate.getIcon();
        }

        @Nullable
        public ProcessHandler getProcessHandler() {
            return this.myDelegate.getProcessHandler();
        }

        public void setProcessHandler(ProcessHandler processHandler) {
            this.myDelegate.setProcessHandler(processHandler);
        }

        public boolean isContentReuseProhibited() {
            return this.myDelegate.isContentReuseProhibited();
        }

        public JComponent getComponent() {
            return this.myDelegate.getComponent();
        }

        public String getDisplayName() {
            return this.myDelegate.getDisplayName();
        }

        public String getHelpId() {
            return this.myDelegate.getHelpId();
        }

        @Nullable
        public Content getAttachedContent() {
            return this.myDelegate.getAttachedContent();
        }

        public void setAttachedContent(@NotNull Content content) {
            this.myDelegate.setAttachedContent(content);
        }

        @Nullable
        public String getContentToolWindowId() {
            return this.myDelegate.getContentToolWindowId();
        }

        public void setContentToolWindowId(@Nullable String contentToolWindowId) {
            this.myDelegate.setContentToolWindowId(contentToolWindowId);
        }

        public boolean isActivateToolWindowWhenAdded() {
            return this.myDelegate.isActivateToolWindowWhenAdded();
        }

        public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
            this.myDelegate.setActivateToolWindowWhenAdded(activateToolWindowWhenAdded);
        }

        public boolean isSelectContentWhenAdded() {
            return this.myDelegate.isSelectContentWhenAdded();
        }

        public void setSelectContentWhenAdded(boolean selectContentWhenAdded) {
            this.myDelegate.setSelectContentWhenAdded(selectContentWhenAdded);
        }

        public boolean isReuseToolWindowActivation() {
            return this.myDelegate.isReuseToolWindowActivation();
        }

        public void setReuseToolWindowActivation(boolean reuseToolWindowActivation) {
            this.myDelegate.setReuseToolWindowActivation(reuseToolWindowActivation);
        }

        public long getExecutionId() {
            return this.myDelegate.getExecutionId();
        }

        public void setExecutionId(long executionId) {
            this.myDelegate.setExecutionId(executionId);
        }

        public String toString() {
            return this.myDelegate.toString();
        }

        public Computable<JComponent> getPreferredFocusComputable() {
            return this.myDelegate.getPreferredFocusComputable();
        }

        public void setFocusComputable(Computable<JComponent> focusComputable) {
            this.myDelegate.setFocusComputable(focusComputable);
        }

        public boolean isAutoFocusContent() {
            return this.myDelegate.isAutoFocusContent();
        }

        public void setAutoFocusContent(boolean autoFocusContent) {
            this.myDelegate.setAutoFocusContent(autoFocusContent);
        }

        @Nullable
        public RunnerLayoutUi getRunnerLayoutUi() {
            return this.myDelegate.getRunnerLayoutUi();
        }

        public void setRunnerLayoutUi(@Nullable RunnerLayoutUi runnerLayoutUi) {
            this.myDelegate.setRunnerLayoutUi(runnerLayoutUi);
        }

        public boolean isHiddenContent() {
            return true;
        }

        @NotNull
        public RunContentDescriptorReusePolicy getReusePolicy() {
            return this.myDelegate.getReusePolicy();
        }

        public void setReusePolicy(@NotNull RunContentDescriptorReusePolicy reusePolicy) {
            this.myDelegate.setReusePolicy(reusePolicy);
        }
    }
}

