/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class AndroidDeviceRenderer
extends ColoredListCellRenderer<DevicePickerEntry> {
    private static final Logger LOG = Logger.getInstance(AndroidDeviceRenderer.class);
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private final SpeedSearchBase mySpeedSearch;
    private final Map<AndroidDevice, SettableFuture<LaunchCompatibility>> myCompatibilityCache = new IdentityHashMap<AndroidDevice, SettableFuture<LaunchCompatibility>>();

    public AndroidDeviceRenderer(@NotNull LaunchCompatibilityChecker checker, @NotNull SpeedSearchBase speedSearch) {
        this.myCompatibilityChecker = checker;
        this.mySpeedSearch = speedSearch;
    }

    public Component getListCellRendererComponent(JList<? extends DevicePickerEntry> list, DevicePickerEntry value2, int index, boolean selected, boolean hasFocus) {
        if (value2 != null && value2.isMarker()) {
            String marker = value2.getMarker();
            assert (marker != null) : "device picker marker entry doesn't have a descriptive string";
            if (value2 == DevicePickerEntry.NONE) {
                return AndroidDeviceRenderer.renderEmptyMarker(marker);
            }
            return AndroidDeviceRenderer.renderTitledSeparator(marker);
        }
        return super.getListCellRendererComponent(list, (Object)value2, index, selected, hasFocus);
    }

    protected void customizeCellRenderer(@NotNull JList list, DevicePickerEntry entry, int index, boolean selected, boolean hasFocus) {
        LaunchCompatibility launchCompatibility;
        boolean compatibilityIsKnown;
        SettableFuture<LaunchCompatibility> compatibilityFuture;
        AndroidDevice device;
        block8: {
            device = entry.getAndroidDevice();
            assert (device != null);
            this.clear();
            if (AndroidDeviceRenderer.shouldShowSerialNumbers(list, device)) {
                this.append("[" + device.getSerial() + "] ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            compatibilityIsKnown = (compatibilityFuture = this.getCachedCompatibilityFuture(device)) != null && compatibilityFuture.isDone();
            launchCompatibility = LaunchCompatibility.YES;
            if (compatibilityIsKnown) {
                try {
                    launchCompatibility = (LaunchCompatibility)compatibilityFuture.get();
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException e) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        boolean compatible = launchCompatibility.isCompatible() != ThreeState.NO;
        device.renderLabel((SimpleColoredComponent)this, compatible, this.mySpeedSearch.getEnteredPrefix());
        if (launchCompatibility.getReason() != null) {
            this.append(" (" + launchCompatibility.getReason() + ")", SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
        }
        if (!compatibilityIsKnown && compatibilityFuture != null) {
            AndroidDeviceRenderer.setPaintBusy(list, true);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                device.prepareToRenderLabel();
                if (!compatibilityFuture.isDone()) {
                    try {
                        compatibilityFuture.set((Object)this.myCompatibilityChecker.validate(device));
                    }
                    catch (Throwable t) {
                        compatibilityFuture.setException(t);
                        LOG.warn(t);
                    }
                }
                EdtInvocationManager.getInstance().invokeLater(() -> {
                    if (list.isDisplayable()) {
                        ListModel model2 = list.getModel();
                        if (model2 instanceof DevicePickerListModel) {
                            ((DevicePickerListModel)model2).entryContentChanged(entry);
                        }
                        AndroidDeviceRenderer.setPaintBusy(list, false);
                    }
                });
            });
        }
    }

    private static void setPaintBusy(JList list, boolean busy) {
        if (list instanceof JBList) {
            ((JBList)list).setPaintBusy(busy);
        }
    }

    private static boolean shouldShowSerialNumbers(@NotNull JList list, @NotNull AndroidDevice device) {
        if (device.isVirtual()) {
            return false;
        }
        ListModel model2 = list.getModel();
        if (model2 instanceof DevicePickerListModel) {
            return ((DevicePickerListModel)model2).shouldShowSerialNumbers();
        }
        return false;
    }

    private static Component renderTitledSeparator(@NotNull String title) {
        TitledSeparator separator = new TitledSeparator(title);
        separator.setBackground(UIUtil.getListBackground());
        separator.setTitleFont(UIUtil.getLabelFont());
        return separator;
    }

    private static Component renderEmptyMarker(@NotNull String title) {
        return new JLabel(title);
    }

    private SettableFuture<LaunchCompatibility> getCachedCompatibilityFuture(AndroidDevice device) {
        SettableFuture compatibilityFuture = this.myCompatibilityCache.get(device);
        if (compatibilityFuture == null) {
            compatibilityFuture = SettableFuture.create();
            this.myCompatibilityCache.put(device, (SettableFuture<LaunchCompatibility>)compatibilityFuture);
            return compatibilityFuture;
        }
        return compatibilityFuture.isDone() ? compatibilityFuture : null;
    }

    public void clearCache() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        this.myCompatibilityCache.clear();
    }
}

