/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.DeepLinkLaunch;
import com.android.tools.idea.run.tasks.ApplyChangesTask;
import com.android.tools.idea.run.tasks.ApplyCodeChangesTask;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.DeployTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.RunInstantAppTask;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.UninstallIotLauncherAppsTask;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.RunStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final Project myProject;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        String packageName;
        ArrayList launchTasks = Lists.newArrayList();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        boolean launchApp = true;
        try {
            LaunchTask appLaunchTask;
            packageName = this.myApplicationIdProvider.getPackageName();
            launchTasks.addAll(this.getDeployTasks(device, packageName));
            StringBuilder amStartOptions = new StringBuilder();
            for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
                String amOptions = taskContributor.getAmStartOptions(this.myFacet.getModule(), packageName, this.myLaunchOptions, device);
                amStartOptions.append(amStartOptions.length() == 0 ? "" : " ").append(amOptions);
                LaunchTask task = taskContributor.getTask(this.myFacet.getModule(), packageName, this.myLaunchOptions);
                if (task == null) continue;
                launchTasks.add(task);
            }
            if (this.shouldApplyChanges() || this.shouldApplyCodeChanges()) {
                launchApp = false;
            }
            if (launchApp && !this.shouldDeployAsInstant() && (appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, amStartOptions.toString(), this.myLaunchOptions.isDebug(), launchStatus)) != null) {
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to determine application id: " + e, launchApp);
            return Collections.emptyList();
        }
        catch (IllegalStateException e) {
            Logger.getInstance(AndroidLaunchTasksProvider.class).error((Throwable)e);
            launchStatus.terminateLaunch(e.getMessage(), launchApp);
            return Collections.emptyList();
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName));
        }
        return launchTasks;
    }

    @NotNull
    List<LaunchTask> getDeployTasks(@NotNull IDevice device, @NotNull String packageName) throws ApkProvisionException {
        if (!this.myLaunchOptions.isDeploy()) {
            return Collections.emptyList();
        }
        ArrayList<LaunchTask> tasks = new ArrayList<LaunchTask>();
        if (((Boolean)StudioFlags.UNINSTALL_LAUNCHER_APPS_ENABLED.get()).booleanValue() && device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            tasks.add(new UninstallIotLauncherAppsTask(this.myProject, packageName));
        }
        List<String> disabledFeatures = this.myLaunchOptions.getDisabledDynamicFeatures();
        if (this.shouldDeployAsInstant()) {
            AndroidRunConfiguration runConfig = (AndroidRunConfiguration)this.myRunConfig;
            DeepLinkLaunch.State state = (DeepLinkLaunch.State)runConfig.getLaunchOptionState("launch_deep_link");
            assert (state != null);
            tasks.add(new RunInstantAppTask(this.myApkProvider.getApks(device), state.DEEP_LINK, disabledFeatures));
        } else {
            ImmutableMap.Builder packages = ImmutableMap.builder();
            for (ApkInfo apkInfo : this.myApkProvider.getApks(device)) {
                packages.put((Object)apkInfo.getApplicationId(), AndroidLaunchTasksProvider.getFilteredFeatures(apkInfo, disabledFeatures));
            }
            if (this.shouldApplyChanges()) {
                tasks.add(new ApplyChangesTask(this.myProject, (Map<String, List<File>>)packages.build(), this.isApplyChangesFallbackToRun()));
            } else if (this.shouldApplyCodeChanges()) {
                tasks.add(new ApplyCodeChangesTask(this.myProject, (Map<String, List<File>>)packages.build(), this.isApplyCodeChangesFallbackToRun()));
            } else {
                tasks.add(new DeployTask(this.myProject, (Map<String, List<File>>)packages.build(), this.myLaunchOptions.getPmInstallOptions()));
            }
        }
        return ImmutableList.copyOf(tasks);
    }

    private boolean isApplyCodeChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CODE_CHANGES_FALLBACK_TO_RUN;
    }

    private boolean isApplyChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CHANGES_FALLBACK_TO_RUN;
    }

    @Override
    public void fillStats(RunStats stats) {
        stats.setApplyChangesFallbackToRun(this.isApplyChangesFallbackToRun());
        stats.setApplyCodeChangesFallbackToRun(this.isApplyCodeChangesFallbackToRun());
    }

    @NotNull
    private static List<File> getFilteredFeatures(ApkInfo apkInfo, List<String> disabledFeatures) {
        if (apkInfo.getFiles().size() > 1) {
            return apkInfo.getFiles().stream().filter(feature -> DynamicAppUtils.isFeatureEnabled(disabledFeatures, feature)).map(file -> file.getApkFile()).collect(Collectors.toList());
        }
        return ImmutableList.of((Object)apkInfo.getFile());
    }

    @NotNull
    private static List<LaunchTask> createDeployTasks(@NotNull Collection<ApkInfo> apks, @NotNull Function<List<ApkInfo>, LaunchTask> singleApkTaskFactory, @NotNull Function<ApkInfo, LaunchTask> splitApkTaskFactory) {
        ArrayList<LaunchTask> result2 = new ArrayList<LaunchTask>();
        ArrayList<ApkInfo> singleApkTasks = new ArrayList<ApkInfo>();
        for (ApkInfo apkInfo : apks) {
            if (apkInfo.getFiles().size() > 1) {
                if (!singleApkTasks.isEmpty()) {
                    result2.add(singleApkTaskFactory.apply((List<ApkInfo>)ImmutableList.copyOf(singleApkTasks)));
                    singleApkTasks.clear();
                }
                result2.add(splitApkTaskFactory.apply(apkInfo));
                continue;
            }
            singleApkTasks.add(apkInfo);
        }
        if (!singleApkTasks.isEmpty()) {
            result2.add(singleApkTaskFactory.apply(singleApkTasks));
        }
        return result2;
    }

    @Override
    @Nullable
    public DebugConnectorTask getConnectDebuggerTask(@NotNull LaunchStatus launchStatus, @Nullable AndroidVersion version2) {
        String packageName;
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        Logger logger = Logger.getInstance(AndroidLaunchTasksProvider.class);
        HashSet packageIds = Sets.newHashSet();
        try {
            packageName = this.myApplicationIdProvider.getPackageName();
            packageIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            logger.error((Throwable)e);
        }
        try {
            packageName = this.myApplicationIdProvider.getTestPackageName();
            if (packageName != null) {
                packageIds.add(packageName);
            }
        }
        catch (ApkProvisionException e) {
            logger.warn("Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        AndroidDebugger debugger = androidDebuggerContext.getAndroidDebugger();
        if (debugger == null) {
            logger.warn("Unable to determine debugger to use for this launch");
            return null;
        }
        logger.info("Using debugger: " + debugger.getId());
        Object androidDebuggerState = androidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            return debugger.getConnectDebuggerTask(this.myEnv, version2, packageIds, this.myFacet, androidDebuggerState, this.myRunConfig.getType().getId(), this.monitorRemoteProcess());
        }
        return null;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return this.myRunConfig.monitorRemoteProcess();
    }

    private boolean shouldDeployAsInstant() {
        return ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4 || this.myLaunchOptions.isDeployAsInstant();
    }

    private boolean shouldApplyChanges() {
        return Boolean.TRUE.equals(this.myEnv.getCopyableUserData(ApplyChangesAction.KEY));
    }

    private boolean shouldApplyCodeChanges() {
        return Boolean.TRUE.equals(this.myEnv.getCopyableUserData(CodeSwapAction.KEY));
    }
}

