/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.ApplicationLogListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;

class AndroidLogcatOutputCapture {
    private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
    private static final Logger LOG = Logger.getInstance(AndroidLogcatOutputCapture.class);
    @NotNull
    private final String myApplicationId;
    @GuardedBy(value="myLock")
    @NotNull
    private final Map<IDevice, AndroidLogcatService.LogcatListener> myLogListeners = new HashMap<IDevice, AndroidLogcatService.LogcatListener>();
    @NotNull
    private final Object myLock = new Object();

    AndroidLogcatOutputCapture(@NotNull String applicationId2) {
        this.myApplicationId = applicationId2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(@NotNull IDevice device, int pid, @NotNull BiConsumer<String, Key> consumer) {
        AndroidLogcatService.LogcatListener previousListener;
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isRunOutputEnabled()) {
            return;
        }
        LOG.info(String.format("startCapture(\"%s\")", device.getName()));
        MyLogcatListener logListener = new MyLogcatListener(this.myApplicationId, pid, device, consumer);
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.put(device, logListener);
        }
        if (previousListener != null) {
            LOG.warn(String.format("The device \"%s\" already has a registered logcat listener for application \"%s\". Removing it", device.getName(), this.myApplicationId));
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture(@NotNull IDevice device) {
        AndroidLogcatService.LogcatListener previousListener;
        LOG.info(String.format("stopCapture(\"%s\")", device.getName()));
        Object object = this.myLock;
        synchronized (object) {
            previousListener = this.myLogListeners.remove(device);
        }
        if (previousListener != null) {
            AndroidLogcatService.getInstance().removeListener(device, previousListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>> listeners;
        LOG.info("stopAll()");
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            listeners = new ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>>(this.myLogListeners.entrySet());
            this.myLogListeners.clear();
        }
        for (Map.Entry entry : listeners) {
            AndroidLogcatService.getInstance().removeListener((IDevice)entry.getKey(), (AndroidLogcatService.LogcatListener)entry.getValue());
        }
    }

    private final class MyLogcatListener
    extends ApplicationLogListener {
        private final AndroidLogcatFormatter myFormatter;
        private final IShellEnabledDevice myDevice;
        private final AtomicBoolean myIsFirstMessage;
        private final BiConsumer<String, Key> myConsumer;

        private MyLogcatListener(String packageName, @NotNull int pid, @NotNull IDevice device, BiConsumer<String, Key> consumer) {
            super(packageName, pid);
            this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
            this.myDevice = device;
            this.myIsFirstMessage = new AtomicBoolean(true);
            this.myConsumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String formatLogLine(@NotNull LogCatMessage line) {
            String message2 = this.myFormatter.formatMessage(SIMPLE_FORMAT, line.getHeader(), line.getMessage());
            Object object = AndroidLogcatOutputCapture.this.myLock;
            synchronized (object) {
                switch (AndroidLogcatOutputCapture.this.myLogListeners.size()) {
                    case 0: 
                    case 1: {
                        return message2;
                    }
                }
                return '[' + this.myDevice.getName() + "]: " + message2;
            }
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message2, @NotNull Key key) {
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myConsumer.accept("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myConsumer.accept(message2, key);
        }
    }
}

