/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidLogcatOutputCapture;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessHandler
extends ProcessHandler
implements KillableProcess,
SwappableProcessHandler,
AndroidDebugBridge.IDeviceChangeListener {
    private static final Logger LOG = Logger.getInstance(AndroidProcessHandler.class);
    @NotNull
    private final DeploymentApplicationService myDeploymentApplicationService;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final Map<IDevice, ProcessInfo> myDeviceProcessMap;
    @NotNull
    private final AndroidLogcatOutputCapture myAndroidLogcatOutputCapture;
    @NotNull
    private final Project myProject;

    private AndroidProcessHandler(@NotNull Project project, @NotNull DeploymentApplicationService deploymentApplicationService, @NotNull String applicationId2) {
        this.myProject = project;
        this.myDeploymentApplicationService = deploymentApplicationService;
        this.myApplicationId = applicationId2;
        this.myDeviceProcessMap = new ConcurrentHashMap<IDevice, ProcessInfo>();
        this.myAndroidLogcatOutputCapture = new AndroidLogcatOutputCapture(applicationId2);
        this.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, this);
    }

    private void addListenersToAdb() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public void addTargetDevice(@NotNull IDevice device) {
        this.myDeviceProcessMap.computeIfAbsent(device, unused -> new ProcessInfo(device));
        AndroidVersion apiLevel = (AndroidVersion)this.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
        AndroidVersion deviceVersion = device.getVersion();
        if (apiLevel == null || apiLevel.compareTo(deviceVersion) > 0) {
            this.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, deviceVersion);
        }
        LOG.info("Adding device " + device.getName() + " to monitor for launched app: " + this.myApplicationId);
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.cleanup();
    }

    protected void destroyProcessImpl() {
        this.notifyProcessTerminated(0);
        this.killApps(this.myDeviceProcessMap.keySet());
    }

    private void killApps(final @NotNull Collection<IDevice> devices) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Stopping Application..."){

            public void run(@NotNull ProgressIndicator indicator) {
                AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
                if (bridge == null) {
                    return;
                }
                for (IDevice device : devices) {
                    AndroidProcessHandler.this.killApp(device);
                }
            }

            public void onSuccess() {
                AndroidProcessHandler.this.cleanup();
            }
        });
    }

    private void killApp(@NotNull IDevice device) {
        if (device.getState() != IDevice.DeviceState.ONLINE) {
            return;
        }
        try {
            device.executeShellCommand("am force-stop " + this.myApplicationId, (IShellOutputReceiver)new NullOutputReceiver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ProcessInfo processInfo = this.myDeviceProcessMap.get(device);
        if (processInfo != null) {
            processInfo.myPidClientMap.values().removeIf(client -> {
                if (client.isValid()) {
                    client.kill();
                }
                return true;
            });
        }
        for (Client client2 : device.getClients()) {
            if (!this.myApplicationId.equals(client2.getClientData().getPackageName())) continue;
            client2.kill();
        }
    }

    private void disassociate(@NotNull IDevice device) {
        this.myAndroidLogcatOutputCapture.stopCapture(device);
        ProcessInfo info = this.myDeviceProcessMap.get(device);
        if (info != null) {
            Disposer.dispose((Disposable)info);
        }
        this.myDeviceProcessMap.remove(device);
    }

    private void cleanup() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myAndroidLogcatOutputCapture.stopAll();
        boolean removedAny = this.myDeviceProcessMap.values().removeIf(processInfo -> {
            Disposer.dispose((Disposable)processInfo);
            return true;
        });
        if (removedAny) {
            this.print("Terminated all processes.", new Object[0]);
        }
    }

    @Nullable
    public Client getClient(@NotNull IDevice device) {
        ProcessInfo info = this.myDeviceProcessMap.get(device);
        if (info == null) {
            return null;
        }
        return info.myPidClientMap.values().stream().findAny().orElse(null);
    }

    private void print(@NotNull String format, Object ... args) {
        this.notifyTextAvailable(String.format(format, args), ProcessOutputTypes.STDOUT);
    }

    public boolean canKillProcess() {
        if (!((Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get()).booleanValue()) {
            return !this.isProcessTerminated() && !this.isProcessTerminating();
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return false;
        }
        ExecutionTarget activeTarget = ExecutionTargetManager.getInstance((Project)this.myProject).getActiveTarget();
        if (activeTarget == DefaultExecutionTarget.INSTANCE || !(activeTarget instanceof AndroidExecutionTarget)) {
            return false;
        }
        IDevice targetIDevice = ((AndroidExecutionTarget)activeTarget).getIDevice();
        return targetIDevice != null && this.myDeviceProcessMap.containsKey(targetIDevice);
    }

    public void killProcess() {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return;
        }
        this.destroyProcess();
    }

    @Override
    @Nullable
    public Executor getExecutor() {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getExecutor();
    }

    @Override
    public boolean isExecutedWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return false;
        }
        return sessionInfo.getExecutionTarget().getId().equals(executionTarget.getId()) && sessionInfo.getRunConfigurationId() == runConfiguration.getUniqueID();
    }

    public void deviceConnected(@NotNull IDevice device) {
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (this.myDeviceProcessMap.containsKey(device)) {
            this.print("Device %s disconnected, monitoring stopped.\n", device.getName());
            this.disassociate(device);
            this.myDeviceProcessMap.remove(device);
        }
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if ((changeMask & 2) != 2) {
            return;
        }
        ProcessInfo processInfo = this.myDeviceProcessMap.get(device);
        if (processInfo == null) {
            return;
        }
        processInfo.onClientListChanged();
    }

    public static class Builder {
        @NotNull
        private final Project myProject;
        private String applicationId;
        private boolean shouldAddListeners = true;
        private DeploymentApplicationService myDeploymentApplicationService;

        public Builder(@NotNull Project project) {
            this.myProject = project;
            this.myDeploymentApplicationService = DeploymentApplicationService.getInstance();
        }

        @NotNull
        public Builder setApplicationId(@NotNull String appId) {
            this.applicationId = appId;
            return this;
        }

        @NotNull
        public Builder monitorRemoteProcesses(boolean shouldMonitorRemoteProcesses) {
            this.shouldAddListeners = shouldMonitorRemoteProcesses;
            return this;
        }

        @NotNull
        @VisibleForTesting
        public Builder setDeploymentApplicationService(@NotNull DeploymentApplicationService deploymentApplicationService) {
            this.myDeploymentApplicationService = deploymentApplicationService;
            return this;
        }

        @NotNull
        public AndroidProcessHandler build() {
            if (this.applicationId == null) {
                throw new IllegalStateException("applicationId not set");
            }
            AndroidProcessHandler handler = new AndroidProcessHandler(this.myProject, this.myDeploymentApplicationService, this.applicationId);
            if (this.shouldAddListeners) {
                handler.addListenersToAdb();
            }
            return handler;
        }
    }

    private class ProcessInfo
    implements Disposable {
        private static final long MAX_RETRY_COUNT = 10L;
        @NotNull
        private final IDevice myDevice;
        @NotNull
        private final Map<Integer, Client> myPidClientMap;
        @NotNull
        private final Future<Void> myClientFuture;
        @NotNull
        private volatile CountDownLatch myAwaitLatch;

        private ProcessInfo(IDevice device) {
            boolean foundClientsInitially;
            this.myDevice = device;
            this.myAwaitLatch = new CountDownLatch(1);
            this.myPidClientMap = new ConcurrentHashMap<Integer, Client>(this.checkForClient());
            boolean bl = foundClientsInitially = !this.myPidClientMap.isEmpty();
            if (foundClientsInitially) {
                this.notifyClientsFound(this.myPidClientMap.keySet());
            } else {
                AndroidProcessHandler.this.print("Waiting for process to come online...\n", new Object[0]);
            }
            this.myClientFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                int retryCount = 0;
                boolean foundClients = foundClientsInitially;
                while ((long)retryCount <= 10L) {
                    try {
                        this.myAwaitLatch.await(1L, TimeUnit.SECONDS);
                        if (this.myAwaitLatch.getCount() == 0L) {
                            this.myAwaitLatch = new CountDownLatch(1);
                        } else {
                            ++retryCount;
                        }
                        Map<Integer, Client> resolvedClients = this.checkForClient();
                        resolvedClients.values().removeIf(client -> !client.isValid());
                        HashMap<Integer, Client> validClients = new HashMap<Integer, Client>(this.myPidClientMap);
                        validClients.values().removeIf(client -> !client.isValid());
                        resolvedClients.keySet().removeAll(validClients.keySet());
                        if (resolvedClients.isEmpty()) continue;
                        this.notifyClientsFound(resolvedClients.keySet());
                        this.myPidClientMap.putAll(resolvedClients);
                        this.myPidClientMap.values().removeIf(client -> !client.isValid());
                        foundClients = true;
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                if (this.myPidClientMap.isEmpty() && !foundClients) {
                    AndroidProcessHandler.this.print("Timed out waiting for process to appear on %s.\n", new Object[]{this.myDevice.getName()});
                }
                return null;
            });
            Disposer.register((Disposable)AndroidProcessHandler.this.myProject, (Disposable)this);
        }

        @NotNull
        private Map<Integer, Client> checkForClient() {
            List<Client> clients = AndroidProcessHandler.this.myDeploymentApplicationService.findClient(this.myDevice, AndroidProcessHandler.this.myApplicationId);
            return clients.isEmpty() ? Collections.emptyMap() : clients.stream().collect(Collectors.toMap(c -> c.getClientData().getPid(), c -> c));
        }

        public void onClientListChanged() {
            this.myAwaitLatch.countDown();
            Map<Integer, Client> validClients = Arrays.stream(this.myDevice.getClients()).collect(Collectors.toMap(client -> client.getClientData().getPid(), client -> client));
            boolean removed = this.myPidClientMap.keySet().removeIf(pid -> {
                if (!validClients.containsKey(pid)) {
                    AndroidProcessHandler.this.print("Process %d terminated.\n", new Object[]{pid});
                    return true;
                }
                return false;
            });
            if (removed && this.myPidClientMap.isEmpty()) {
                AndroidProcessHandler.this.disassociate(this.myDevice);
                return;
            }
            this.myPidClientMap.replaceAll((pid, client) -> (Client)validClients.get(pid));
        }

        private void notifyClientsFound(@NotNull Set<Integer> pids) {
            for (int pid : pids) {
                AndroidProcessHandler.this.print("Connected to process %d on device '%s'.\n", new Object[]{pid, this.myDevice.getName()});
                AndroidProcessHandler.this.myAndroidLogcatOutputCapture.startCapture(this.myDevice, pid, (arg_0, arg_1) -> ((AndroidProcessHandler)AndroidProcessHandler.this).notifyTextAvailable(arg_0, arg_1));
            }
        }

        public void dispose() {
            this.myClientFuture.cancel(true);
            this.myAwaitLatch.countDown();
            try {
                this.myClientFuture.get();
                this.myPidClientMap.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

