/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessText {
    private static final Key<AndroidProcessText> KEY = new Key("ANDROID_PROCESS_TEXT");
    private final List<MyFragment> myFragments = new ArrayList<MyFragment>();

    private AndroidProcessText(@NotNull ProcessHandler processHandler) {
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                List list = AndroidProcessText.this.myFragments;
                synchronized (list) {
                    AndroidProcessText.this.myFragments.add(new MyFragment(event.getText(), outputType));
                }
            }
        });
        processHandler.putUserData(KEY, (Object)this);
    }

    public static void attach(@NotNull ProcessHandler processHandler) {
        new AndroidProcessText(processHandler);
    }

    @Nullable
    public static AndroidProcessText get(@NotNull ProcessHandler processHandler) {
        return (AndroidProcessText)processHandler.getUserData(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTo(@NotNull ProcessHandler processHandler) {
        List<MyFragment> list = this.myFragments;
        synchronized (list) {
            for (MyFragment fragment : this.myFragments) {
                processHandler.notifyTextAvailable(fragment.getText(), fragment.getOutputType());
            }
        }
    }

    private static class MyFragment {
        private final String myText;
        private final Key myOutputType;

        private MyFragment(@NotNull String text, @NotNull Key outputType) {
            this.myText = text;
            this.myOutputType = outputType;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        @NotNull
        public Key getOutputType() {
            return this.myOutputType;
        }
    }
}

