/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRemoteDebugProcessHandler
extends ProcessHandler
implements SwappableProcessHandler {
    private final Project myProject;
    private final boolean myDetachWhenDoneMonitoring;

    public AndroidRemoteDebugProcessHandler(Project project, boolean detachWhenDoneMonitoring) {
        this.myProject = project;
        this.myDetachWhenDoneMonitoring = detachWhenDoneMonitoring;
        this.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, this);
    }

    public void startNotify() {
        final DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        DebugProcessListener listener2 = new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process, boolean closedByUser) {
                debugProcess.removeDebugProcessListener((DebugProcessListener)this);
                if (AndroidRemoteDebugProcessHandler.this.myDetachWhenDoneMonitoring) {
                    AndroidRemoteDebugProcessHandler.this.notifyProcessDetached();
                }
            }
        };
        debugProcess.addDebugProcessListener(listener2);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess.isDetached()) {
                debugProcess.removeDebugProcessListener(listener2);
                if (this.myDetachWhenDoneMonitoring) {
                    this.notifyProcessDetached();
                }
            }
        }
    }

    protected void destroyProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(true);
        }
        this.notifyProcessTerminated(0);
    }

    protected void detachProcessImpl() {
        DebugProcess debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess != null) {
            debugProcess.stop(false);
        }
        this.notifyProcessDetached();
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    @Override
    @Nullable
    public Executor getExecutor() {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return null;
        }
        return sessionInfo.getExecutor();
    }

    @Override
    public boolean isExecutedWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
        AndroidSessionInfo sessionInfo = (AndroidSessionInfo)this.getUserData(AndroidSessionInfo.KEY);
        if (sessionInfo == null) {
            return false;
        }
        return sessionInfo.getExecutionTarget().getId().equals(executionTarget.getId()) && sessionInfo.getRunConfigurationId() == runConfiguration.getUniqueID();
    }
}

