/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.stats.RunStatsService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements PreferGradleMake {
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState;
    private final boolean myAndroidTests;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");
    @Transient
    @NotNull
    protected final transient DefaultPostBuildModelProvider myOutputProvider = new DefaultPostBuildModelProvider();

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myProfilerState = new ProfilerState();
        this.myAndroidTests = androidTests;
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        AndroidFacet facet;
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject() && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 2) {
            if (((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() || ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 5) {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet);
                if (!((Boolean)result2.getFirst()).booleanValue()) {
                    errors.add(ValidationError.fatal((String)result2.getSecond()));
                }
            } else {
                errors.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
            }
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (facet.getManifest() == null && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 4) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet));
        errors.addAll(this.getApkProvider(facet, this.getApplicationIdProvider(facet), new ArrayList<AndroidDevice>()).validate());
        errors.addAll(this.checkConfiguration(facet));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet, executor));
        }
        errors.addAll(this.myProfilerState.validate());
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        return LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        return this.getDeployTargetContext().getApplicableDeployTargetProviders(this.myAndroidTests);
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        List<ValidationError> errors = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state = this.doGetState(executor, env, stats);
            stats.markStateCreated();
            return state;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        String error;
        this.validateBeforeRun(executor);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        stats.setDebuggable(LaunchUtils.canDebugApp(facet));
        stats.setExecutor(executor.getId());
        this.updateExtraRunStats(stats);
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        boolean userSelectedDeployTarget = this.requiresUserSelection(executor, isDebugging, facet);
        stats.setUserSelectedTarget(userSelectedDeployTarget);
        DeployTarget deployTarget = this.getDeployTarget(executor, env, isDebugging, facet);
        if (deployTarget == null) {
            return null;
        }
        DeployTargetState deployTargetState = this.getDeployTargetContext().getCurrentDeployTargetState();
        if (deployTarget.hasCustomRunProfileState(executor)) {
            return deployTarget.getRunProfileState(executor, env, deployTargetState);
        }
        DeviceFutures deviceFutures = deployTarget.getDevices(deployTargetState, facet, this.getDeviceCount(isDebugging), isDebugging, this.hashCode());
        if (deviceFutures == null) {
            return null;
        }
        stats.setLaunchedDevices(deviceFutures.getDevices().stream().anyMatch(device -> device instanceof LaunchableAndroidDevice));
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet, module.getName())) != null) {
            throw new ExecutionException(error);
        }
        env.putCopyableUserData(DeviceFutures.KEY, (Object)deviceFutures);
        env.putUserData(RunStats.KEY, (Object)stats);
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider(facet);
        LaunchOptions.Builder launchOptions = this.getLaunchOptions().setDebug(isDebugging);
        if (executor instanceof LaunchOptionsProvider) {
            launchOptions.addExtraOptions(((LaunchOptionsProvider)executor).getLaunchOptions());
        }
        ApkProvider apkProvider = this.getApkProvider(facet, applicationIdProvider, deviceFutures.getDevices());
        AndroidLaunchTasksProvider launchTasksProvider = new AndroidLaunchTasksProvider(this, env, facet, applicationIdProvider, apkProvider, launchOptions.build());
        return new AndroidRunState(env, this.getName(), module, applicationIdProvider, this.getConsoleProvider(), deviceFutures, launchTasksProvider);
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet, @NotNull String moduleName) {
        for (ListenableFuture<IDevice> future2 : deviceFutures.get()) {
            IDevice device;
            if (!future2.isDone() || LaunchUtils.canDebugAppOnDevice(facet, device = (IDevice)Futures.getUnchecked(future2))) continue;
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName, device.getName());
        }
        return null;
    }

    private boolean requiresUserSelection(@NotNull Executor executor, boolean debug, @NotNull AndroidFacet facet) {
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        if (currentTargetProvider instanceof ShowChooserTargetProvider) {
            return currentTargetProvider.requiresRuntimePrompt() && ((ShowChooserTargetProvider)currentTargetProvider).getCachedDeployTarget(executor, facet, this.getDeviceCount(debug), this.getDeployTargetContext().getDeployTargetStates(), this.hashCode()) == null;
        }
        return currentTargetProvider.requiresRuntimePrompt();
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, boolean debug, @NotNull AndroidFacet facet) {
        DeployTarget deployTarget;
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        if (currentTargetProvider.requiresRuntimePrompt()) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet, this.getDeviceCount(debug), this.myAndroidTests, this.getDeployTargetContext().getDeployTargetStates(), this.hashCode(), LaunchCompatibilityCheckerImpl.create(facet, env, this));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget(this.getProject());
        }
        return deployTarget;
    }

    @Nullable
    public ApplicationIdProvider getApplicationIdProvider() {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            Logger.getInstance(AndroidRunConfigurationBase.class).warn("Can't get application ID: Android module missing");
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        if (facet.isDisposed()) {
            Logger.getInstance(AndroidRunConfigurationBase.class).warn("Can't get application ID: Facet already disposed");
            return null;
        }
        if (!((AndroidFacetConfiguration)facet.getConfiguration()).isAppProject() && ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() != 2) {
            if (((AndroidFacetConfiguration)facet.getConfiguration()).isLibraryProject() || ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 5) {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet);
                if (!((Boolean)result2.getFirst()).booleanValue()) {
                    Logger.getInstance(AndroidRunConfigurationBase.class).info("Application ID: " + (String)result2.getSecond());
                }
            } else {
                Logger.getInstance(AndroidRunConfigurationBase.class).info("Application ID: Unknown APK type");
            }
        }
        return this.getApplicationIdProvider(facet);
    }

    @NotNull
    public ApplicationIdProvider getApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() instanceof AndroidModuleModel) {
            return new GradleApplicationIdProvider(facet, this.myOutputProvider);
        }
        return new NonGradleApplicationIdProvider(facet);
    }

    @NotNull
    protected abstract ApkProvider getApkProvider(@NotNull AndroidFacet var1, @NotNull ApplicationIdProvider var2, @NotNull List<AndroidDevice> var3);

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider();

    @Nullable
    protected abstract LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, @NotNull String var3, boolean var4, @NotNull LaunchStatus var5);

    @NotNull
    protected ApkProvider createGradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test, @NotNull List<AndroidDevice> targetDevices) {
        Computable outputKindProvider = () -> {
            if (DynamicAppUtils.useSelectApksFromBundleBuilder(facet.getModule(), (RunConfiguration)this, targetDevices)) {
                return GradleApkProvider.OutputKind.AppBundleOutputModel;
            }
            return GradleApkProvider.OutputKind.Default;
        };
        return new GradleApkProvider(facet, applicationIdProvider, this.myOutputProvider, test, (Computable<GradleApkProvider.OutputKind>)outputKindProvider);
    }

    public boolean monitorRemoteProcess() {
        return true;
    }

    @NotNull
    public final DeviceCount getDeviceCount(boolean debug) {
        return DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
    }

    protected abstract boolean supportMultipleDevices();

    public void updateExtraRunStats(RunStats runStats) {
    }

    public void setOutputModel(@NotNull PostBuildModel outputModel) {
        this.myOutputProvider.setOutputModel(outputModel);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        return this.myDeployTargetContext;
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        return this.myAndroidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        return this.myProfilerState;
    }

    private static class DefaultPostBuildModelProvider
    implements PostBuildModelProvider {
        @Transient
        @Nullable
        private transient PostBuildModel myBuildOutputs = null;

        private DefaultPostBuildModelProvider() {
        }

        public void setOutputModel(@NotNull PostBuildModel postBuildModel) {
            this.myBuildOutputs = postBuildModel;
        }

        @Override
        @Nullable
        public PostBuildModel getPostBuildModel() {
            return this.myBuildOutputs;
        }
    }
}

