/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.LazyUtil;
import icons.StudioIcons;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class AndroidRunConfigurationType
extends ConfigurationTypeBase {
    public AndroidRunConfigurationType() {
        super("AndroidRunConfigurationType", AndroidBundle.message("android.run.configuration.type.name", new Object[0]), AndroidBundle.message("android.run.configuration.type.description", new Object[0]), LazyUtil.create(() -> StudioIcons.Shell.Filetree.ANDROID_PROJECT));
        this.addFactory(new AndroidRunConfigurationFactory((ConfigurationType)this));
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.AndroidRunConfigurationType";
    }

    public static AndroidRunConfigurationType getInstance() {
        return (AndroidRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidRunConfigurationType.class);
    }

    public ConfigurationFactory getFactory() {
        return this.getConfigurationFactories()[0];
    }

    public boolean isDumbAware() {
        return true;
    }

    public static class AndroidRunConfigurationFactory
    extends ConfigurationFactory {
        protected AndroidRunConfigurationFactory(@NotNull ConfigurationType type) {
            super(type);
        }

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new AndroidRunConfiguration(project, this);
        }

        @NotNull
        public RunConfigurationSingletonPolicy getSingletonPolicy() {
            return RunConfigurationSingletonPolicy.MULTIPLE_INSTANCE;
        }

        public boolean isApplicable(@NotNull Project project) {
            return ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID);
        }

        public void configureBeforeRunTaskDefaults(Key<? extends BeforeRunTask> providerID, BeforeRunTask task) {
            if (CompileStepBeforeRun.ID.equals(providerID)) {
                task.setEnabled(false);
            }
        }
    }
}

