/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.LaunchTaskRunner;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.android.tools.idea.stats.RunStats;
import com.google.common.base.MoreObjects;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final String myLaunchConfigName;
    @NotNull
    private final Module myModule;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final ConsoleProvider myConsoleProvider;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @Nullable
    private final ProcessHandler myPreviousSessionProcessHandler;

    public AndroidRunState(@NotNull ExecutionEnvironment env, @NotNull String launchConfigName, @NotNull Module module, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ConsoleProvider consoleProvider, @NotNull DeviceFutures deviceFutures, @NotNull AndroidLaunchTasksProvider launchTasksProvider) {
        this.myEnv = env;
        this.myLaunchConfigName = launchConfigName;
        this.myModule = module;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myConsoleProvider = consoleProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        AndroidSessionInfo existingSessionInfo = AndroidSessionInfo.findOldSession(env.getProject(), null, ((AndroidRunConfigurationBase)env.getRunProfile()).getUniqueID(), env.getExecutionTarget());
        this.myPreviousSessionProcessHandler = existingSessionInfo != null ? existingSessionInfo.getProcessHandler() : null;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ExecutionConsole console;
        ProcessHandler processHandler;
        String applicationId2;
        RunStats stats = RunStats.from(this.myEnv);
        try {
            applicationId2 = this.myApplicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to obtain application id", (Throwable)e);
        }
        stats.setPackage(applicationId2);
        boolean isSwap = (Boolean)MoreObjects.firstNonNull((Object)this.myEnv.getCopyableUserData(CodeSwapAction.KEY), (Object)Boolean.FALSE) != false || (Boolean)MoreObjects.firstNonNull((Object)this.myEnv.getCopyableUserData(ApplyChangesAction.KEY), (Object)Boolean.FALSE) != false;
        RunContentManager manager = RunContentManager.getInstance((Project)this.myEnv.getProject());
        RunContentDescriptor previousDescriptor = manager.findContentDescriptor(executor, this.myPreviousSessionProcessHandler);
        if (!isSwap) {
            if (this.myPreviousSessionProcessHandler != null) {
                if (previousDescriptor != null && !manager.removeRunContent(executor, previousDescriptor)) {
                    return null;
                }
                this.myPreviousSessionProcessHandler.detachProcess();
            }
            processHandler = new AndroidProcessHandler.Builder(this.myEnv.getProject()).setApplicationId(applicationId2).monitorRemoteProcesses(this.myLaunchTasksProvider.monitorRemoteProcess()).build();
            console = this.attachConsole(processHandler, executor);
        } else {
            assert (this.myPreviousSessionProcessHandler != null) : "No process handler from previous session, yet current tasks don't create one";
            processHandler = this.myPreviousSessionProcessHandler;
            console = previousDescriptor == null ? null : previousDescriptor.getExecutionConsole();
            Object object = console = console == null ? this.attachConsole(processHandler, executor) : console;
        }
        BiConsumer<String, HyperlinkInfo> hyperlinkConsumer = console instanceof ConsoleView ? (arg_0, arg_1) -> ((ConsoleView)((ConsoleView)console)).printHyperlink(arg_0, arg_1) : (s, h) -> {};
        LaunchInfo launchInfo = new LaunchInfo(executor, runner, this.myEnv, this.myConsoleProvider);
        LaunchTaskRunner task = new LaunchTaskRunner(this.myModule.getProject(), this.myLaunchConfigName, this.myEnv.getExecutionTarget().getDisplayName(), launchInfo, processHandler, this.myDeviceFutures, this.myLaunchTasksProvider, stats, hyperlinkConsumer);
        ProgressManager.getInstance().run((Task)task);
        return new DefaultExecutionResult(console, processHandler);
    }

    @NotNull
    public ConsoleView attachConsole(@NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        return this.myConsoleProvider.createAndAttach((Disposable)this.myModule.getProject(), processHandler, executor);
    }
}

