/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    @NotNull
    private final String myExecutorId;
    @NotNull
    private final String myExecutorActionName;
    private final int myRunConfigId;
    @NotNull
    private final ExecutionTarget myExecutionTarget;

    public AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor2, int runConfigId, @NotNull String executorId, @NotNull String executorActionName, @NotNull ExecutionTarget executionTarget) {
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor2;
        this.myRunConfigId = runConfigId;
        this.myExecutorId = executorId;
        this.myExecutorActionName = executorActionName;
        this.myExecutionTarget = executionTarget;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    @Nullable
    public Executor getExecutor() {
        return ExecutorRegistry.getInstance().getExecutorById(this.getExecutorId());
    }

    @NotNull
    public String getExecutorActionName() {
        return this.myExecutorActionName;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        return this.myExecutionTarget;
    }

    public int getRunConfigurationId() {
        return this.myRunConfigId;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, int currentID, @NotNull ExecutionTarget executionTarget) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info;
            if (handler.isProcessTerminated() || handler.isProcessTerminating() || (info = (AndroidSessionInfo)handler.getUserData(KEY)) == null || currentID != info.getRunConfigurationId() || executor != null && !executor.getId().equals(info.getExecutorId()) || !executionTarget.equals((Object)info.getExecutionTarget())) continue;
            return info;
        }
        return null;
    }
}

