/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.deployable.ApplicationIdResolver;
import com.android.tools.idea.run.deployable.DeviceVersion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class DeploymentApplicationService
implements Disposable {
    private final ApplicationIdResolver myApplicationIdResolver = new ApplicationIdResolver();
    private final DeviceVersion myDeviceVersion = new DeviceVersion();

    @NotNull
    public static DeploymentApplicationService getInstance() {
        return (DeploymentApplicationService)ServiceManager.getService(DeploymentApplicationService.class);
    }

    private DeploymentApplicationService() {
    }

    public void dispose() {
        this.myDeviceVersion.dispose();
        this.myApplicationIdResolver.dispose();
    }

    @NotNull
    public List<Client> findClient(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        return this.myApplicationIdResolver.resolve(iDevice, applicationId2);
    }

    @NotNull
    public Future<AndroidVersion> getVersion(@NotNull IDevice iDevice) {
        return this.myDeviceVersion.get(iDevice);
    }
}

