/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.deployer.ApkFileDatabase;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.tasks.TaskRunner;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentService {
    private final Project project;
    private final ExecutorService service;
    private final TaskRunner runner;
    private final ApkFileDatabase dexDatabase;
    @Nullable
    private DeployableProvider myDeployableProvider = null;

    @NotNull
    public static DeploymentService getInstance(@NotNull Project project) {
        return (DeploymentService)ServiceManager.getService((Project)project, DeploymentService.class);
    }

    private DeploymentService(@NotNull Project project) {
        this.project = project;
        this.service = Executors.newFixedThreadPool(5);
        this.runner = new TaskRunner(this.service);
        Path path = Paths.get(PathManager.getSystemPath(), ".deploy.db");
        this.dexDatabase = new SqlApkFileDatabase(new File(path.toString()));
    }

    public TaskRunner getTaskRunner() {
        return this.runner;
    }

    public ApkFileDatabase getDexDatabase() {
        return this.dexDatabase;
    }

    public void setDeployableProvider(@Nullable DeployableProvider provider) {
        this.myDeployableProvider = provider;
    }

    @Nullable
    public DeployableProvider getDeployableProvider() {
        return this.myDeployableProvider;
    }
}

