/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.Key;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceFutures {
    public static final Key<DeviceFutures> KEY = Key.create((String)"android.run.devicefutures");
    @NotNull
    private final List<AndroidDevice> myDevices;

    public DeviceFutures(@NotNull List<AndroidDevice> devices) {
        this.myDevices = devices;
    }

    @NotNull
    public List<ListenableFuture<IDevice>> get() {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (AndroidDevice device : this.myDevices) {
            futures.add(device.getLaunchedDevice());
        }
        return futures.build();
    }

    @Nullable
    public List<IDevice> getIfReady() {
        List<ListenableFuture<IDevice>> devices = this.get();
        for (ListenableFuture<IDevice> deviceFuture : devices) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (List)Futures.getChecked((Future)Futures.allAsList(devices), ExecutionException.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public List<AndroidDevice> getDevices() {
        return this.myDevices;
    }

    @NotNull
    public static DeviceFutures forDevices(@NotNull Iterable<IDevice> devices) {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)new ConnectedAndroidDevice(device, null));
        }
        return new DeviceFutures((List<AndroidDevice>)futures.build());
    }

    public boolean allMatch(@Nullable DeviceFutures other) {
        if (other == null) {
            return false;
        }
        return this.getDevices().stream().allMatch((? super T device) -> other.getDevices().stream().anyMatch(selectedDevice -> selectedDevice.getSerial().equals(device.getSerial())));
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof DeviceFutures)) {
            return false;
        }
        return this.myDevices.equals(((DeviceFutures)object).myDevices);
    }

    public int hashCode() {
        return this.myDevices.hashCode();
    }
}

