/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserDialog;
import com.android.tools.idea.run.DeviceCount;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceSelectionUtils {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DeviceSelectionUtils.class);
    @NonNls
    private static final String ANDROID_TARGET_DEVICES_PROPERTY = "AndroidTargetDevices";

    @Nullable
    public static Collection<IDevice> chooseRunningDevice(final @NotNull AndroidFacet facet, final @NotNull Predicate<IDevice> deviceFilter, final @NotNull DeviceCount deviceCount) {
        List<IDevice> compatibleDevices = DeviceSelectionUtils.getAllCompatibleDevices(deviceFilter);
        if (compatibleDevices.isEmpty()) {
            return ImmutableList.of();
        }
        if (compatibleDevices.size() == 1) {
            return compatibleDevices;
        }
        final AtomicReference devicesRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                devicesRef.set(DeviceSelectionUtils.chooseDevicesManually(facet, (Predicate<IDevice>)deviceFilter, deviceCount));
            }
        });
        return ((IDevice[])devicesRef.get()).length > 0 ? ImmutableList.copyOf((Object[])((Object[])devicesRef.get())) : null;
    }

    @NotNull
    public static List<IDevice> getAllCompatibleDevices(Predicate<IDevice> deviceFilter) {
        ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>();
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge != null) {
            IDevice[] devices;
            for (IDevice device : devices = bridge.getDevices()) {
                if (!deviceFilter.apply((Object)device)) continue;
                compatibleDevices.add(device);
            }
        }
        return compatibleDevices;
    }

    @NotNull
    public static Collection<IDevice> getOnlineDevices(@Nullable Collection<IDevice> devices) {
        if (devices == null) {
            return Collections.emptyList();
        }
        ArrayList online = Lists.newArrayListWithExpectedSize((int)devices.size());
        for (IDevice device : devices) {
            if (!device.isOnline()) continue;
            online.add(device);
        }
        return online;
    }

    @NotNull
    private static IDevice[] chooseDevicesManually(@NotNull AndroidFacet facet, @NotNull Predicate<IDevice> filter2, @NotNull DeviceCount deviceCount) {
        Project project = facet.getModule().getProject();
        String value2 = PropertiesComponent.getInstance((Project)project).getValue(ANDROID_TARGET_DEVICES_PROPERTY);
        String[] selectedSerials = value2 != null ? DeviceSelectionUtils.deserialize(value2) : null;
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            LOG.error("Android platform not set for module: " + facet.getModule().getName());
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        DeviceChooserDialog chooser2 = new DeviceChooserDialog(facet, platform.getTarget(), deviceCount.isMultiple(), selectedSerials, filter2);
        chooser2.show();
        IDevice[] devices = chooser2.getSelectedDevices();
        if (chooser2.getExitCode() != 0 || devices.length == 0) {
            return DeviceChooser.EMPTY_DEVICE_ARRAY;
        }
        PropertiesComponent.getInstance((Project)project).setValue(ANDROID_TARGET_DEVICES_PROPERTY, DeviceSelectionUtils.serialize(devices));
        return devices;
    }

    @NotNull
    public static String serialize(@NotNull IDevice[] devices) {
        StringBuilder builder = new StringBuilder();
        int n = devices.length;
        for (int i2 = 0; i2 < n; ++i2) {
            builder.append(devices[i2].getSerialNumber());
            if (i2 >= n - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    @NotNull
    private static String[] deserialize(@NotNull String s) {
        return s.split(" ");
    }
}

