/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AvdManagerUtils;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AvdManagerLog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetChooser {
    private static final Logger LOG = Logger.getInstance(EmulatorTargetChooser.class);
    private final String myAvd;
    @NotNull
    private final AndroidFacet myFacet;

    public EmulatorTargetChooser(@NotNull AndroidFacet facet, @Nullable String avd) {
        this.myFacet = facet;
        assert (avd == null || !avd.isEmpty());
        this.myAvd = avd;
    }

    @Nullable
    public DeviceFutures getDevices(@NotNull DeviceCount deviceCount) {
        String avd;
        TargetDeviceFilter.EmulatorFilter deviceFilter = new TargetDeviceFilter.EmulatorFilter(this.myFacet, this.myAvd);
        Collection<IDevice> runningDevices = DeviceSelectionUtils.chooseRunningDevice(this.myFacet, deviceFilter, deviceCount);
        if (runningDevices == null) {
            return null;
        }
        if (!runningDevices.isEmpty()) {
            return DeviceFutures.forDevices(runningDevices);
        }
        String string = avd = this.myAvd != null ? this.myAvd : this.chooseAvd();
        if (avd == null) {
            return null;
        }
        AvdManager manager = AvdManagerUtils.getAvdManagerSilently(this.myFacet);
        if (manager == null) {
            LOG.warn("Could not obtain AVD Manager.");
            return null;
        }
        AvdInfo avdInfo = manager.getAvd(avd, true);
        if (avdInfo == null) {
            LOG.warn("Unable to obtain info for AVD: " + avd);
            return null;
        }
        LaunchableAndroidDevice androidDevice = new LaunchableAndroidDevice(avdInfo);
        androidDevice.launch(this.myFacet.getModule().getProject());
        return new DeviceFutures(Collections.singletonList(androidDevice));
    }

    @Nullable
    private String chooseAvd() {
        AvdManager manager;
        IAndroidTarget buildTarget = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidTarget();
        assert (buildTarget != null);
        List<AvdInfo> avds = EmulatorTargetChooser.getValidCompatibleAvds(this.myFacet);
        if (!avds.isEmpty()) {
            return avds.get(0).getName();
        }
        Project project = this.myFacet.getModule().getProject();
        try {
            manager = AvdManager.getInstance((AndroidSdkHandler)AndroidSdkData.getSdkHolder(this.myFacet), (ILogger)new AvdManagerLog(){

                @Override
                public void error(Throwable t, String errorFormat, Object ... args) {
                    super.error(t, errorFormat, args);
                    if (errorFormat != null) {
                        String msg = String.format(errorFormat, args);
                        LOG.error(msg);
                    }
                }
            });
        }
        catch (AndroidLocation.AndroidLocationException e) {
            LOG.info((Throwable)e);
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)CommonBundle.getErrorTitle()));
            return null;
        }
        AvdManager finalManager = manager;
        assert (finalManager != null);
        return (String)UIUtil.invokeAndWaitIfNeeded(() -> {
            AvdOptionsModel avdOptionsModel;
            ModelWizardDialog dialog2;
            int result2 = Messages.showDialog((Project)project, (String)"To run using the emulator, you must have an AVD defined.", (String)"Define AVD", (String[])new String[]{"Cancel", "Create AVD"}, (int)1, null);
            AvdInfo createdAvd = null;
            if (result2 == 1 && (dialog2 = AvdWizardUtils.createAvdWizard(null, project, avdOptionsModel = new AvdOptionsModel(null))).showAndGet()) {
                createdAvd = avdOptionsModel.getCreatedAvd();
            }
            return createdAvd == null ? null : createdAvd.getName();
        });
    }

    @NotNull
    private static List<AvdInfo> getValidCompatibleAvds(@NotNull AndroidFacet facet) {
        AvdManager manager = AvdManagerUtils.getAvdManagerSilently(facet);
        if (manager == null || !AvdManagerUtils.reloadAvds(manager, facet.getModule().getProject())) {
            return ImmutableList.of();
        }
        AndroidVersion minSdk = AndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            Logger.getInstance(EmulatorTargetChooser.class).error("Android Platform not set for module: " + facet.getModule().getName());
            return ImmutableList.of();
        }
        return EmulatorTargetChooser.getCompatibleAvds(manager.getValidAvds(), minSdk, platform);
    }

    @NotNull
    private static List<AvdInfo> getCompatibleAvds(@NotNull AvdInfo[] allAvds, @NotNull AndroidVersion minSdk, @NotNull AndroidPlatform platform) {
        return Arrays.stream(allAvds).filter(info -> {
            ISystemImage systemImage = info.getSystemImage();
            return systemImage != null && LaunchCompatibility.canRunOnAvd(minSdk, platform.getTarget(), systemImage).isCompatible() != ThreeState.NO;
        }).collect(Collectors.toList());
    }

    @NotNull
    public List<ValidationError> validate() {
        if (this.myAvd == null) {
            return ImmutableList.of();
        }
        AvdManager avdManager = AvdManagerUtils.getAvdManagerSilently(this.myFacet);
        if (avdManager == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
        }
        AvdInfo avdInfo = avdManager.getAvd(this.myAvd, false);
        if (avdInfo == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.myAvd)));
        }
        if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
            String message2 = avdInfo.getErrorMessage();
            message2 = AndroidBundle.message("avd.not.valid.error", this.myAvd) + (message2 != null ? ": " + message2 : "") + ". Try to repair it through AVD manager";
            return ImmutableList.of((Object)ValidationError.fatal(message2));
        }
        return ImmutableList.of();
    }
}

