/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleApplicationIdProvider
implements ApplicationIdProvider {
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet) {
        this(facet, () -> null);
    }

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet, @NotNull PostBuildModelProvider outputModelProvider) {
        this.myFacet = facet;
        this.myOutputModelProvider = outputModelProvider;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 2) {
            AndroidFacet targetFacet = this.getTargetFacet();
            if (targetFacet != null) {
                GradleApplicationIdProvider targetApplicationProvider = new GradleApplicationIdProvider(targetFacet, this.myOutputModelProvider);
                return targetApplicationProvider.getPackageName();
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get applicationId for tested module.");
        }
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4) {
            String applicationId2 = this.tryToGetInstantAppApplicationId();
            if (applicationId2 != null) {
                return applicationId2;
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get instant app applicationId from post build model.");
        }
        return ApkProviderUtil.computePackageName(this.myFacet);
    }

    @Nullable
    private String tryToGetInstantAppApplicationId() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null || !androidModel.getFeatures().isPostBuildSyncSupported() || androidModel.getAndroidProject().getProjectType() != 4) {
            return null;
        }
        PostBuildModel postBuildModel = this.myOutputModelProvider.getPostBuildModel();
        if (postBuildModel == null) {
            return null;
        }
        InstantAppProjectBuildOutput projectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(this.myFacet);
        if (projectBuildOutput == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : projectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
            return variantBuildOutput.getApplicationId();
        }
        return null;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 2) {
            return ApkProviderUtil.computePackageName(this.myFacet);
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        String testPackageName = androidModel == null ? null : androidModel.getSelectedVariant().getMergedFlavor().getTestApplicationId();
        return testPackageName != null ? testPackageName : this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    @Nullable
    private AndroidFacet getTargetFacet() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            return null;
        }
        Collection targetVariants = androidModel.getSelectedVariant().getTestedTargetVariants();
        if (targetVariants.size() != 1) {
            return null;
        }
        TestedTargetVariant targetVariant = (TestedTargetVariant)targetVariants.iterator().next();
        Module targetModule = GradleUtil.findModuleByGradlePath(this.myFacet.getModule().getProject(), targetVariant.getTargetProjectPath());
        if (targetModule == null) {
            return null;
        }
        return AndroidFacet.getInstance(targetModule);
    }

    private static Logger getLogger() {
        return Logger.getInstance(GradleApplicationIdProvider.class);
    }
}

