/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.android.tools.idea.run.util.LaunchUtils;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchCompatibilityCheckerImpl
implements LaunchCompatibilityChecker {
    @NotNull
    private final AndroidVersion myMinSdkVersion;
    @NotNull
    private final IAndroidTarget myProjectTarget;
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    @Nullable
    private final AndroidRunConfigurationBase myAndroidRunConfigurationBase;
    @Nullable
    private final Set<String> mySupportedAbis;

    public LaunchCompatibilityCheckerImpl(@NotNull AndroidVersion minSdkVersion2, @NotNull IAndroidTarget target, @NotNull AndroidFacet facet, @Nullable ExecutionEnvironment environment, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase, @Nullable Set<String> supportedAbis) {
        assert (environment == null && androidRunConfigurationBase == null || environment != null && androidRunConfigurationBase != null);
        this.myMinSdkVersion = minSdkVersion2;
        this.myProjectTarget = target;
        this.myEnvironment = environment;
        this.myAndroidRunConfigurationBase = androidRunConfigurationBase;
        this.myFacet = facet;
        this.mySupportedAbis = supportedAbis;
    }

    @NotNull
    private EnumSet<IDevice.HardwareFeature> getRequiredHardwareFeauters() {
        if (LaunchUtils.isWatchFeatureRequired(this.myFacet)) {
            return EnumSet.of(IDevice.HardwareFeature.WATCH);
        }
        return EnumSet.noneOf(IDevice.HardwareFeature.class);
    }

    @Override
    @Slow
    @NotNull
    public LaunchCompatibility validate(@NotNull AndroidDevice device) {
        LaunchCompatibility launchCompatibility = LaunchCompatibility.YES;
        if (this.myEnvironment != null && this.myAndroidRunConfigurationBase != null) {
            Boolean applyChanges2 = (Boolean)this.myEnvironment.getCopyableUserData(ApplyChangesAction.KEY);
            Boolean codeSwap = (Boolean)this.myEnvironment.getCopyableUserData(CodeSwapAction.KEY);
            if (applyChanges2 != null && applyChanges2.booleanValue() || codeSwap != null && codeSwap.booleanValue()) {
                if (device.getVersion().compareTo(26, null) < 0) {
                    launchCompatibility = new LaunchCompatibility(ThreeState.NO, "The device needs to be running Oreo or newer.");
                } else if (!device.isRunning()) {
                    launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Please ensure the target device/emulator is running.");
                } else {
                    try {
                        ApplicationIdProvider applicationIdProvider = this.myAndroidRunConfigurationBase.getApplicationIdProvider(this.myFacet);
                        Client client = ((IDevice)device.getLaunchedDevice().get()).getClient(applicationIdProvider.getPackageName());
                        if (client == null) {
                            launchCompatibility = new LaunchCompatibility(ThreeState.NO, "App not running on device. Please first install/run the app on the target device/emulator.");
                        }
                    }
                    catch (ApkProvisionException | InterruptedException | ExecutionException e) {
                        launchCompatibility = new LaunchCompatibility(ThreeState.NO, "Could not determine if device is compatible.");
                    }
                }
            }
        }
        return launchCompatibility.combine(device.canRun(this.myMinSdkVersion, this.myProjectTarget, this.getRequiredHardwareFeauters(), this.mySupportedAbis));
    }

    public static LaunchCompatibilityChecker create(@NotNull AndroidFacet facet, @Nullable ExecutionEnvironment env, @Nullable AndroidRunConfigurationBase androidRunConfigurationBase) {
        AndroidVersion minSdkVersion2 = AndroidModuleInfo.getInstance(facet).getRuntimeMinSdkVersion();
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            throw new IllegalStateException("Android platform not set for module: " + facet.getModule().getName());
        }
        Set supportedAbis = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() instanceof AndroidModuleModel ? ((AndroidModuleModel)((AndroidFacetConfiguration)facet.getConfiguration()).getModel()).getSelectedVariant().getMainArtifact().getAbiFilters() : null;
        return new LaunchCompatibilityCheckerImpl(minSdkVersion2, platform.getTarget(), facet, env, androidRunConfigurationBase, supportedAbis);
    }
}

