/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.stats.RunStats;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @Nullable
    private final String myExecutionTargetName;
    @NotNull
    private final LaunchInfo myLaunchInfo;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @NotNull
    private final RunStats myStats;
    @NotNull
    private final BiConsumer<String, HyperlinkInfo> myConsoleConsumer;
    @NotNull
    private final List<Runnable> myOnFinished;
    @Nullable
    private String myError;
    @Nullable
    private NotificationListener myErrorNotificationListener;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @Nullable String executionTargetName, @NotNull LaunchInfo launchInfo, @NotNull ProcessHandler processHandler, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider, @NotNull RunStats stats, @NotNull BiConsumer<String, HyperlinkInfo> consoleConsumer) {
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myExecutionTargetName = executionTargetName;
        this.myLaunchInfo = launchInfo;
        this.myProcessHandler = processHandler;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        this.myStats = stats;
        this.myConsoleConsumer = consoleConsumer;
        this.myOnFinished = new ArrayList<Runnable>();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        DebugConnectorTask debugSessionTask;
        indicator.setText(this.getTitle());
        indicator.setIndeterminate(false);
        this.myStats.beginLaunchTasks();
        ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus(this.myProcessHandler);
        ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter(this.myProcessHandler);
        List<ListenableFuture<IDevice>> listenableDeviceFutures = this.myDeviceFutures.get();
        AndroidVersion androidVersion = this.myDeviceFutures.getDevices().size() == 1 ? this.myDeviceFutures.getDevices().get(0).getVersion() : null;
        DebugConnectorTask debugConnectorTask = debugSessionTask = this.isSwap() ? null : this.myLaunchTasksProvider.getConnectDebuggerTask(launchStatus, androidVersion);
        if (debugSessionTask != null && listenableDeviceFutures.size() != 1) {
            launchStatus.terminateLaunch("Cannot launch a debug session on more than 1 device.", true);
        }
        if (debugSessionTask != null) {
            AndroidProcessText.attach(this.myProcessHandler);
        }
        StringBuilder launchString = new StringBuilder("\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        launchString.append(dateFormat.format(new Date())).append(": ");
        launchString.append(this.getLaunchVerb()).append(" ");
        launchString.append("'").append(this.myConfigName).append("'");
        if (!StringUtil.isEmpty((String)this.myExecutionTargetName)) {
            launchString.append(" on ");
            launchString.append(this.myExecutionTargetName);
        }
        launchString.append(".");
        consolePrinter.stdout(launchString.toString());
        for (ListenableFuture<IDevice> deviceFuture : listenableDeviceFutures) {
            indicator.setText("Waiting for target device to come online");
            this.myStats.beginWaitForDevice();
            IDevice device = this.waitForDevice(deviceFuture, indicator, launchStatus);
            this.myStats.endWaitForDevice(device);
            if (device == null) break;
            List<LaunchTask> launchTasks = null;
            try {
                this.myLaunchTasksProvider.fillStats(this.myStats);
                launchTasks = this.myLaunchTasksProvider.getTasks(device, launchStatus, consolePrinter);
            }
            catch (com.intellij.execution.ExecutionException e) {
                launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                break;
            }
            catch (IllegalStateException e) {
                launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                Logger.getInstance(LaunchTaskRunner.class).error((Throwable)e);
                break;
            }
            int totalDuration = listenableDeviceFutures.size() * LaunchTaskRunner.getTotalDuration(launchTasks, debugSessionTask);
            int elapsed = 0;
            boolean success = true;
            for (LaunchTask task : launchTasks) {
                LaunchTaskDetail.Builder details = this.myStats.beginLaunchTask(task);
                indicator.setText(task.getDescription());
                LaunchResult result2 = task.run(this.myLaunchInfo.executor, device, launchStatus, consolePrinter);
                this.myOnFinished.addAll(result2.onFinishedCallbacks());
                success = result2.getSuccess();
                this.myStats.endLaunchTask(task, details, success);
                if (!success) {
                    this.myErrorNotificationListener = result2.getNotificationListener();
                    this.myError = result2.getError();
                    launchStatus.terminateLaunch(result2.getConsoleError(), !this.isSwap());
                    if (result2.getConsoleHyperlinkInfo() != null) {
                        this.myConsoleConsumer.accept(result2.getConsoleHyperlinkText() + "\n", result2.getConsoleHyperlinkInfo());
                    }
                    RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myLaunchInfo.executor, this.myProcessHandler);
                    this.myStats.setErrorId(result2.getErrorId());
                    break;
                }
                indicator.setFraction((double)(elapsed += task.getDuration()) / (double)totalDuration);
                if (indicator.isCanceled()) {
                    launchStatus.terminateLaunch("User cancelled launch", !this.isSwap());
                    success = false;
                    break;
                }
                if (!launchStatus.isLaunchTerminated()) continue;
                success = false;
                break;
            }
            if (!success) break;
            if (debugSessionTask != null) {
                debugSessionTask.perform(this.myLaunchInfo, device, launchStatus, consolePrinter);
                continue;
            }
            if (!(this.myProcessHandler instanceof AndroidProcessHandler)) continue;
            AndroidProcessHandler procHandler = (AndroidProcessHandler)this.myProcessHandler;
            procHandler.addTargetDevice(device);
        }
        this.myStats.endLaunchTasks();
    }

    public void onSuccess() {
        if (this.myError == null) {
            this.myStats.success();
        } else {
            this.myStats.fail();
            LaunchUtils.showNotification(this.myProject, this.myLaunchInfo.executor, this.myConfigName, this.myError, NotificationType.ERROR, this.myErrorNotificationListener);
        }
    }

    public void onFinished() {
        super.onFinished();
        for (Runnable runnable : this.myOnFinished) {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    @Nullable
    private IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus) {
        do {
            try {
                return (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device", true);
                return null;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage(), true);
                return null;
            }
            if (!indicator.isCanceled()) continue;
            launchStatus.terminateLaunch("User cancelled launch", !this.isSwap());
            return null;
        } while (!launchStatus.isLaunchTerminated());
        return null;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, @Nullable DebugConnectorTask debugSessionTask) {
        int total = 0;
        for (LaunchTask task : launchTasks) {
            total += task.getDuration();
        }
        if (debugSessionTask != null) {
            total += debugSessionTask.getDuration();
        }
        return total;
    }

    private boolean isSwap() {
        return Boolean.TRUE.equals(this.myLaunchInfo.env.getCopyableUserData(ApplyChangesAction.KEY)) || Boolean.TRUE.equals(this.myLaunchInfo.env.getCopyableUserData(CodeSwapAction.KEY));
    }

    @NotNull
    private String getLaunchVerb() {
        if (Boolean.TRUE.equals(this.myLaunchInfo.env.getCopyableUserData(ApplyChangesAction.KEY))) {
            return "Applying changes to";
        }
        if (Boolean.TRUE.equals(this.myLaunchInfo.env.getCopyableUserData(CodeSwapAction.KEY))) {
            return "Applying code changes to";
        }
        return "Launching";
    }
}

