/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessHandlerConsolePrinter
implements ConsolePrinter {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<Message> myStoredMessages = Lists.newArrayList();
    @Nullable
    private ProcessHandler myProcessHandler;

    public ProcessHandlerConsolePrinter(@Nullable ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    @Override
    public void stdout(@NotNull String text) {
        this.print(text, ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(@NotNull String text) {
        this.print(text, ProcessOutputTypes.STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessHandler(@NotNull ProcessHandler processHandler) {
        ArrayList storedMessages;
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            this.myProcessHandler = processHandler;
            storedMessages = Lists.newArrayList(this.myStoredMessages);
            this.myStoredMessages.clear();
        }
        for (Message message2 : storedMessages) {
            this.print(message2.text, message2.outputType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(@NotNull String text, @NotNull Key outputType) {
        ProcessHandler processHandler;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProcessHandler == null) {
                this.myStoredMessages.add(new Message(text, outputType));
                return;
            }
            processHandler = this.myProcessHandler;
        }
        assert (!Thread.holdsLock(this.myLock));
        processHandler.notifyTextAvailable(text + '\n', outputType);
    }

    private static class Message {
        @NotNull
        final String text;
        @NotNull
        final Key outputType;

        Message(@NotNull String text, @NotNull Key outputType) {
            this.text = text;
            this.outputType = outputType;
        }
    }
}

