/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.deployable.Device;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationIdResolver
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, Device> myDevices = new ConcurrentHashMap<IDevice, Device>();
    @NotNull
    private final ExecutorService myApplicationIdResolverExecutor = new ThreadPoolExecutor(0, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("package-name-resolver-%d").build());

    public ApplicationIdResolver() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myApplicationIdResolverExecutor.shutdownNow();
    }

    @NotNull
    public List<Client> resolve(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        Device device = this.myDevices.get(iDevice);
        return device == null ? Collections.emptyList() : device.findClientWithApplicationId(applicationId2);
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected() && bridge.hasInitialDeviceList()) {
            for (IDevice iDevice : bridge.getDevices()) {
                this.refresh(iDevice);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        this.refresh(device);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        this.myDevices.remove(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if ((changeMask & 3) != 0) {
            this.refresh(device);
        }
    }

    private void refresh(@NotNull IDevice iDevice) {
        this.myDevices.compute(iDevice, (ignored, device) -> {
            if (!iDevice.isOnline()) {
                return null;
            }
            Device newDevice = device;
            if (newDevice == null) {
                newDevice = new Device(this.myApplicationIdResolverExecutor, iDevice);
            }
            newDevice.refresh();
            return newDevice;
        });
    }
}

