/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.deployable.Process;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Device {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("^package:(\\S+)\\s+.*");
    @NotNull
    private final ExecutorService myResolverExecutor;
    @NotNull
    private final IDevice myIDevice;
    @NotNull
    private final Map<Integer, Process> myPidToProcess = new ConcurrentHashMap<Integer, Process>();
    @NotNull
    private final Map<String, Future<Void>> myResolutions = new ConcurrentHashMap<String, Future<Void>>();

    Device(@NotNull ExecutorService resolverExecutor, @NotNull IDevice device) {
        this.myResolverExecutor = resolverExecutor;
        this.myIDevice = device;
    }

    @NotNull
    public List<Client> findClientWithApplicationId(@NotNull String applicationId2) {
        if (this.isLegacyDevice()) {
            this.myResolutions.computeIfAbsent(applicationId2, ignored -> this.resolveLegacyPid(applicationId2));
        }
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Process process : this.myPidToProcess.values()) {
            if (!applicationId2.equals(process.getApplicationId())) continue;
            clients.add(process.getClient());
        }
        if (clients.isEmpty()) {
            for (Client client : this.myIDevice.getClients()) {
                if (!applicationId2.equals(client.getClientData().getClientDescription()) && !applicationId2.equals(client.getClientData().getPackageName())) continue;
                clients.add(client);
            }
        }
        return clients;
    }

    synchronized void refresh() {
        HashMap<Integer, Client> clients = new HashMap<Integer, Client>(this.myIDevice.getClients().length);
        for (Client client : this.myIDevice.getClients()) {
            clients.put(client.getClientData().getPid(), client);
        }
        this.myPidToProcess.keySet().retainAll(clients.keySet());
        this.myPidToProcess.keySet().forEach(pid -> {
            Client client = (Client)clients.get(pid);
            if (client != null) {
                this.myPidToProcess.get(pid).setClient(client);
            }
        });
        HashSet addedPids = new HashSet(clients.keySet());
        addedPids.removeAll(this.myPidToProcess.keySet());
        addedPids.forEach(pid -> {
            Client client = (Client)clients.get(pid);
            Process process = new Process(client);
            if (!this.isLegacyDevice()) {
                this.resolveApplicationId(process);
            }
            this.myPidToProcess.put((Integer)pid, process);
        });
        if (this.isLegacyDevice() && !addedPids.isEmpty()) {
            this.myResolutions.values().removeIf(resolution -> {
                resolution.cancel(true);
                return true;
            });
        }
    }

    private boolean isLegacyDevice() {
        return this.myIDevice.getVersion().getFeatureLevel() < 26;
    }

    private void resolveApplicationId(@NotNull Process process) {
        this.myResolverExecutor.submit(() -> {
            String command = String.format("stat -c %%u /proc/%d | xargs -n 1 pm list packages --uid", process.getPid());
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            if (output.isEmpty()) {
                return null;
            }
            Matcher m = PACKAGE_NAME_PATTERN.matcher(output);
            if (m.find()) {
                process.setApplicationId(m.group(1));
            }
            return null;
        });
    }

    @NotNull
    private Future<Void> resolveLegacyPid(@NotNull String applicationId2) {
        return this.myResolverExecutor.submit(() -> {
            String command = String.format("uid=`run-as %s whoami` && for pid in `run-as %s ps | grep -o -p \"$uid[[:space:]]\\{1,\\}[[:digit:]]\\{1,\\}\" | tr -s ' ' ' ' | cut -d ' ' -f2`; do   if [[ `run-as %s readlink /proc/$pid/exe` == /system/bin/app_process* ]]; then     echo $pid;   fi; done", applicationId2, applicationId2, applicationId2);
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.myIDevice.executeShellCommand(command, (IShellOutputReceiver)receiver);
            String output = receiver.getOutput();
            if (output.isEmpty()) {
                return null;
            }
            String[] lines = output.split("\n");
            try {
                for (String line : lines) {
                    int pid = Integer.parseInt(line);
                    this.myPidToProcess.computeIfPresent(pid, (ignored, process) -> {
                        process.setApplicationId(applicationId2);
                        return process;
                    });
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        });
    }
}

