/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.ConnectedDevicesWorkerDelegate;
import com.android.tools.idea.run.deployment.DefaultCallback;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDevicesWorkerDelegate;
import com.android.tools.idea.run.deployment.Worker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Streams;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncDevicesGetter {
    @NotNull
    private final Project myProject;
    @NotNull
    private final KeyToConnectionTimeMap myMap;
    @NotNull
    private final Worker<Collection<VirtualDevice>> myVirtualDevicesWorker;
    @NotNull
    private final Worker<Collection<ConnectedDevice>> myConnectedDevicesWorker;
    @NotNull
    private final DeviceNamePropertiesFetcher myDevicePropertiesFetcher;
    @Nullable
    private LaunchCompatibilityChecker myChecker;

    private AsyncDevicesGetter(@NotNull Project project) {
        this(project, new KeyToConnectionTimeMap());
    }

    @VisibleForTesting
    AsyncDevicesGetter(@NotNull Project project, @NotNull KeyToConnectionTimeMap map2) {
        this.myProject = project;
        this.myMap = map2;
        this.myVirtualDevicesWorker = new Worker(() -> new VirtualDevicesWorkerDelegate(this.myChecker));
        this.myConnectedDevicesWorker = new Worker(() -> new ConnectedDevicesWorkerDelegate(project, this.myChecker));
        this.myDevicePropertiesFetcher = new DeviceNamePropertiesFetcher(new DefaultCallback<DeviceNameProperties>(), (Disposable)project);
    }

    @NotNull
    List<Device> get() {
        if (Disposer.isDisposed((Disposable)this.myDevicePropertiesFetcher)) {
            return Collections.emptyList();
        }
        this.initChecker(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), AndroidFacet::getInstance);
        return this.getImpl(this.myVirtualDevicesWorker.get(), this.myConnectedDevicesWorker.get());
    }

    @NotNull
    @VisibleForTesting
    List<Device> getImpl(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        Stream deviceStream = Streams.concat((Stream[])new Stream[]{this.connectedVirtualDeviceStream(connectedDevices, virtualDevices), this.physicalDeviceStream(connectedDevices), AsyncDevicesGetter.disconnectedVirtualDeviceStream(virtualDevices, connectedDevices)});
        List<Device> devices = deviceStream.collect(Collectors.toList());
        Collection keys = devices.stream().filter(Device::isConnected).map(Device::getKey).collect(Collectors.toList());
        this.myMap.retainAll(keys);
        return devices;
    }

    @NotNull
    private Stream<VirtualDevice> connectedVirtualDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices, @NotNull Collection<VirtualDevice> virtualDevices) {
        Map<String, VirtualDevice> keyToVirtualDeviceMap = virtualDevices.stream().collect(Collectors.toMap(Device::getKey, device -> device));
        return connectedDevices.stream().filter(device -> keyToVirtualDeviceMap.containsKey(device.getVirtualDeviceKey())).map(device -> VirtualDevice.newConnectedDevice((VirtualDevice)keyToVirtualDeviceMap.get(device.getVirtualDeviceKey()), device, this.myMap));
    }

    @NotNull
    private Stream<PhysicalDevice> physicalDeviceStream(@NotNull Collection<ConnectedDevice> connectedDevices) {
        return connectedDevices.stream().filter(device -> device.getVirtualDeviceKey() == null).map(device -> PhysicalDevice.newDevice(device, this.myDevicePropertiesFetcher, this.myMap));
    }

    @NotNull
    private static Stream<VirtualDevice> disconnectedVirtualDeviceStream(@NotNull Collection<VirtualDevice> virtualDevices, @NotNull Collection<ConnectedDevice> connectedDevices) {
        Collection connectedVirtualDeviceKeys = connectedDevices.stream().map(ConnectedDevice::getVirtualDeviceKey).collect(Collectors.toSet());
        return virtualDevices.stream().filter(device -> !connectedVirtualDeviceKeys.contains(device.getKey()));
    }

    @VisibleForTesting
    final void initChecker(@Nullable RunnerAndConfigurationSettings configurationAndSettings, @NotNull Function<Module, AndroidFacet> facetGetter) {
        if (configurationAndSettings == null) {
            this.myChecker = null;
            return;
        }
        RunConfiguration configuration = configurationAndSettings.getConfiguration();
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            this.myChecker = null;
            return;
        }
        Module module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (module == null) {
            this.myChecker = null;
            return;
        }
        AndroidFacet facet = facetGetter.apply(module);
        if (facet == null) {
            this.myChecker = null;
            return;
        }
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            this.myChecker = null;
            return;
        }
        this.myChecker = LaunchCompatibilityCheckerImpl.create(facet, null, null);
    }

    @VisibleForTesting
    final Object getChecker() {
        return this.myChecker;
    }
}

