/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployment.Device;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConnectedDevice
extends Device {
    @VisibleForTesting
    ConnectedDevice(@NotNull Builder builder) {
        super(builder);
    }

    @Nullable
    String getVirtualDeviceKey() {
        return Objects.requireNonNull(this.getDdmlibDevice()).getAvdName();
    }

    @NotNull
    String getPhysicalDeviceName(@NotNull DeviceNamePropertiesFetcher fetcher) {
        return ConnectedDevice.getName(fetcher.get(Objects.requireNonNull(this.getDdmlibDevice())));
    }

    @NotNull
    @VisibleForTesting
    static String getName(@NotNull DeviceNameProperties properties) {
        String manufacturer = properties.getManufacturer();
        String model2 = properties.getModel();
        if (manufacturer == null && model2 == null) {
            return "Unknown Device";
        }
        if (manufacturer == null) {
            return model2;
        }
        if (model2 == null) {
            return manufacturer + " Device";
        }
        return manufacturer + ' ' + model2;
    }

    @Override
    @NotNull
    final Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    @Override
    final boolean isConnected() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    final Collection<String> getSnapshots() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    final Future<AndroidVersion> getAndroidVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    final void addTo(@NotNull DeviceFutures futures, @NotNull Project project, @Nullable String snapshot) {
        throw new UnsupportedOperationException();
    }

    static class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        final Builder setValid(boolean valid) {
            this.myValid = valid;
            return this;
        }

        @NotNull
        final Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            return this;
        }

        @NotNull
        Builder setKey(@NotNull String key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @Override
        @NotNull
        ConnectedDevice build() {
            return new ConnectedDevice(this);
        }
    }
}

