/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.WorkerDelegate;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevicesWorkerDelegate
extends WorkerDelegate<Collection<ConnectedDevice>> {
    @NotNull
    private final Project myProject;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    ConnectedDevicesWorkerDelegate(@NotNull Project project, @Nullable LaunchCompatibilityChecker checker) {
        super(Collections.emptyList());
        this.myProject = project;
        this.myChecker = checker;
    }

    @Override
    @NotNull
    public Collection<ConnectedDevice> construct() {
        File adb = AndroidSdkUtils.getAdb(this.myProject);
        if (adb == null) {
            return Collections.emptyList();
        }
        ListenableFuture<AndroidDebugBridge> futureBridge = AdbService.getInstance().getDebugBridge(adb);
        if (!futureBridge.isDone()) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(((AndroidDebugBridge)futureBridge.get()).getDevices()).map(this::newConnectedDevice).collect(Collectors.toList());
        }
        catch (InterruptedException exception) {
            throw new AssertionError((Object)exception);
        }
        catch (ExecutionException exception) {
            Logger.getInstance(ConnectedDevicesWorkerDelegate.class).warn((Throwable)exception);
            return Collections.emptyList();
        }
    }

    @NotNull
    private ConnectedDevice newConnectedDevice(@NotNull IDevice ddmlibDevice) {
        ConnectedAndroidDevice androidDevice = new ConnectedAndroidDevice(ddmlibDevice, null);
        ConnectedDevice.Builder builder = new ConnectedDevice.Builder().setName("Connected Device").setKey(ddmlibDevice.getSerialNumber()).setAndroidDevice(androidDevice);
        if (this.myChecker == null) {
            return builder.build();
        }
        LaunchCompatibility compatibility = this.myChecker.validate(androidDevice);
        return builder.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
    }
}

