/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployable.Deployable;
import com.intellij.openapi.project.Project;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Device {
    @NotNull
    private final String myName;
    private final boolean myValid;
    @Nullable
    private final String myValidityReason;
    @NotNull
    private final String myKey;
    @Nullable
    private final Instant myConnectionTime;
    @NotNull
    private final AndroidDevice myAndroidDevice;

    Device(@NotNull Builder builder) {
        assert (builder.myName != null);
        this.myName = builder.myName;
        this.myValid = builder.myValid;
        this.myValidityReason = builder.myValidityReason;
        assert (builder.myKey != null);
        this.myKey = builder.myKey;
        this.myConnectionTime = builder.myConnectionTime;
        assert (builder.myAndroidDevice != null);
        this.myAndroidDevice = builder.myAndroidDevice;
    }

    @NotNull
    abstract Icon getIcon();

    abstract boolean isConnected();

    @NotNull
    public final String getName() {
        return this.myName;
    }

    final boolean isValid() {
        return this.myValid;
    }

    @Nullable
    final String getValidityReason() {
        return this.myValidityReason;
    }

    @NotNull
    abstract Collection<String> getSnapshots();

    @NotNull
    final String getKey() {
        return this.myKey;
    }

    @Nullable
    final Instant getConnectionTime() {
        return this.myConnectionTime;
    }

    @NotNull
    final AndroidDevice getAndroidDevice() {
        return this.myAndroidDevice;
    }

    @NotNull
    abstract Future<AndroidVersion> getAndroidVersion();

    final boolean isRunning(@NotNull String appPackage) {
        if (!this.isConnected()) {
            return false;
        }
        IDevice device = this.getDdmlibDevice();
        assert (device != null);
        if (!device.isOnline()) {
            return false;
        }
        return !Deployable.searchClientsForPackage(device, appPackage).isEmpty();
    }

    @Nullable
    final IDevice getDdmlibDevice() {
        AndroidDevice device = this.getAndroidDevice();
        if (!device.isRunning()) {
            return null;
        }
        try {
            return (IDevice)device.getLaunchedDevice().get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    abstract void addTo(@NotNull DeviceFutures var1, @NotNull Project var2, @Nullable String var3);

    @NotNull
    public final String toString() {
        return this.myName;
    }

    static abstract class Builder {
        @Nullable
        String myName;
        boolean myValid = true;
        @Nullable
        String myValidityReason;
        @Nullable
        String myKey;
        @Nullable
        Instant myConnectionTime;
        @Nullable
        AndroidDevice myAndroidDevice;

        Builder() {
        }

        @NotNull
        abstract Device build();
    }
}

