/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.CellRenderer;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotExecutionTargetProvider;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.Heading;
import com.android.tools.idea.run.deployment.RunOnMultipleDevicesAction;
import com.android.tools.idea.run.deployment.SelectDeviceAndSnapshotAction;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxAction
extends ComboBoxAction {
    @VisibleForTesting
    static final String SELECTED_DEVICE = "DeviceAndSnapshotComboBoxAction.selectedDevice";
    private static final String SELECTION_TIME = "DeviceAndSnapshotComboBoxAction.selectionTime";
    public static final Key<Boolean> DEPLOYS_TO_LOCAL_DEVICE = Key.create((String)"DeviceAndSnapshotComboBoxAction.deploysToLocalDevice");
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxVisible;
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    private final Function<Project, AsyncDevicesGetter> myDevicesGetterGetter;
    @NotNull
    private final Function<Project, PropertiesComponent> myGetProperties;
    private final AnAction myRunOnMultipleDevicesAction;
    private final AnAction myOpenAvdManagerAction;
    private final Clock myClock;
    private String mySelectedSnapshot;

    private DeviceAndSnapshotComboBoxAction() {
        this(() -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get(), () -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED.get(), project -> (AsyncDevicesGetter)ServiceManager.getService((Project)project, AsyncDevicesGetter.class), PropertiesComponent::getInstance, Clock.systemDefaultZone());
    }

    @VisibleForTesting
    public DeviceAndSnapshotComboBoxAction(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxVisible, @NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxSnapshotsEnabled, @NotNull Function<Project, AsyncDevicesGetter> devicesGetterGetter, @NotNull Function<Project, PropertiesComponent> getProperties2, @NotNull Clock clock) {
        this.mySelectDeviceSnapshotComboBoxVisible = selectDeviceSnapshotComboBoxVisible;
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myDevicesGetterGetter = devicesGetterGetter;
        this.myGetProperties = getProperties2;
        this.myRunOnMultipleDevicesAction = new RunOnMultipleDevicesAction();
        this.myOpenAvdManagerAction = new RunAndroidAvdManagerAction();
        Presentation presentation = this.myOpenAvdManagerAction.getTemplatePresentation();
        presentation.setIcon(StudioIcons.Shell.Toolbar.DEVICE_MANAGER);
        presentation.setText("Open AVD Manager");
        this.myClock = clock;
    }

    boolean areSnapshotsEnabled() {
        return this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get();
    }

    @NotNull
    @VisibleForTesting
    final AnAction getRunOnMultipleDevicesAction() {
        return this.myRunOnMultipleDevicesAction;
    }

    @NotNull
    @VisibleForTesting
    final AnAction getOpenAvdManagerAction() {
        return this.myOpenAvdManagerAction;
    }

    @NotNull
    public List<Device> getDevices(@NotNull Project project) {
        List<Device> devices = this.myDevicesGetterGetter.apply(project).get();
        devices.sort(new DeviceComparator());
        return devices;
    }

    @Nullable
    final Device getSelectedDevice(@NotNull Project project) {
        List<Device> devices = this.getDevices(project);
        if (devices.isEmpty()) {
            return null;
        }
        PropertiesComponent properties = this.myGetProperties.apply(project);
        String key = properties.getValue(SELECTED_DEVICE);
        Optional<Device> optionalSelectedDevice = devices.stream().filter(device -> device.getKey().equals(key)).findFirst();
        if (!optionalSelectedDevice.isPresent()) {
            return devices.get(0);
        }
        Device selectedDevice = optionalSelectedDevice.get();
        if (selectedDevice.isConnected()) {
            return selectedDevice;
        }
        Optional<Device> optionalConnectedDevice = devices.stream().filter(Device::isConnected).findFirst();
        if (optionalConnectedDevice.isPresent()) {
            Device connectedDevice = optionalConnectedDevice.get();
            Instant connectionTime = connectedDevice.getConnectionTime();
            assert (connectionTime != null) : "connected device \"" + connectedDevice + "\" has a null connection time";
            if (DeviceAndSnapshotComboBoxAction.getSelectionTime(selectedDevice, properties).isBefore(connectionTime)) {
                return connectedDevice;
            }
        }
        return selectedDevice;
    }

    @NotNull
    private static Instant getSelectionTime(@NotNull Device device, @NotNull PropertiesComponent properties) {
        String time2 = properties.getValue(SELECTION_TIME);
        if (time2 == null) {
            Logger.getInstance(DeviceAndSnapshotComboBoxAction.class).warn("selected device \"" + device + "\" has a null selection time string");
            return Instant.MIN;
        }
        return Instant.parse(time2);
    }

    final void setSelectedDevice(@NotNull Project project, @Nullable Device selectedDevice) {
        PropertiesComponent properties = this.myGetProperties.apply(project);
        if (selectedDevice == null) {
            properties.unsetValue(SELECTED_DEVICE);
            properties.unsetValue(SELECTION_TIME);
        } else {
            properties.setValue(SELECTED_DEVICE, selectedDevice.getKey());
            properties.setValue(SELECTION_TIME, this.myClock.instant().toString());
        }
        DeviceAndSnapshotComboBoxAction.updateExecutionTargetManager(project, selectedDevice);
    }

    @Nullable
    final String getSelectedSnapshot() {
        return this.mySelectedSnapshot;
    }

    final void setSelectedSnapshot(@Nullable String selectedSnapshot) {
        this.mySelectedSnapshot = selectedSnapshot;
    }

    @NotNull
    public final JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout2 = new GroupLayout(panel2);
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation);
        GroupLayout.SequentialGroup horizontalGroup = layout2.createSequentialGroup().addComponent((Component)button2, 0, JBUI.scale((int)-1), JBUI.scale((int)Short.MAX_VALUE)).addGap(JBUI.scale((int)3));
        GroupLayout.ParallelGroup verticalGroup = layout2.createParallelGroup().addComponent((Component)button2);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        return panel2;
    }

    @NotNull
    protected final ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        ComboBoxAction.ComboBoxButton button2 = new ComboBoxAction.ComboBoxButton(presentation){

            protected JBPopup createPopup(@NotNull Runnable runnable) {
                DataContext context = this.getDataContext();
                DefaultActionGroup group = DeviceAndSnapshotComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this), context);
                boolean show = DeviceAndSnapshotComboBoxAction.this.shouldShowDisabledActions();
                int count = DeviceAndSnapshotComboBoxAction.this.getMaxRows();
                Condition condition = DeviceAndSnapshotComboBoxAction.this.getPreselectCondition();
                PopupFactoryImpl.ActionGroupPopup popup2 = new PopupFactoryImpl.ActionGroupPopup(null, (ActionGroup)group, context, false, true, show, false, runnable, count, condition, null, true);
                popup2.setMinimumSize(new Dimension(DeviceAndSnapshotComboBoxAction.this.getMinWidth(), DeviceAndSnapshotComboBoxAction.this.getMinHeight()));
                popup2.getList().setCellRenderer(new CellRenderer((ListPopupImpl)popup2));
                return popup2;
            }
        };
        button2.setName("deviceAndSnapshotComboBoxButton");
        return button2;
    }

    protected final boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    protected final DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected final DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context) {
        DefaultActionGroup group = new DefaultActionGroup();
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Collection<AnAction> actions2 = this.newSelectDeviceAndSnapshotActions(project);
        group.addAll(actions2);
        if (!actions2.isEmpty()) {
            group.addSeparator();
        }
        group.add(this.myRunOnMultipleDevicesAction);
        group.add(this.myOpenAvdManagerAction);
        AnAction action2 = DeviceAndSnapshotComboBoxAction.getTroubleshootDeviceConnectionsAction();
        if (action2 == null) {
            return group;
        }
        group.addSeparator();
        group.add(action2);
        return group;
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceAndSnapshotActions(@NotNull Project project) {
        boolean disconnectedDevicesPresent;
        Map<Boolean, List<Device>> connectednessToDeviceMap = this.getDevices(project).stream().collect(Collectors.groupingBy(Device::isConnected));
        Collection connectedDevices = connectednessToDeviceMap.getOrDefault(true, Collections.emptyList());
        Collection disconnectedDevices = connectednessToDeviceMap.getOrDefault(false, Collections.emptyList());
        boolean connectedDevicesPresent = !connectedDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(connectedDevices.size() + disconnectedDevices.size() + 3);
        if (connectedDevicesPresent) {
            actions2.add(new Heading("Running devices"));
        }
        connectedDevices.stream().map(device -> this.newSelectDeviceAndSnapshotAction(project, (Device)device)).forEach(actions2::add);
        boolean bl = disconnectedDevicesPresent = !disconnectedDevices.isEmpty();
        if (connectedDevicesPresent && disconnectedDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (disconnectedDevicesPresent) {
            actions2.add(new Heading("Available devices"));
        }
        disconnectedDevices.stream().map(device -> this.newSelectDeviceAndSnapshotAction(project, (Device)device)).forEach(actions2::add);
        return actions2;
    }

    @NotNull
    private AnAction newSelectDeviceAndSnapshotAction(@NotNull Project project, @NotNull Device device) {
        return new SelectDeviceAndSnapshotAction.Builder().setComboBoxAction(this).setProject(project).setDevice(device).build();
    }

    @Nullable
    private static AnAction getTroubleshootDeviceConnectionsAction() {
        AnAction action2 = ActionManager.getInstance().getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            return null;
        }
        Presentation presentation = action2.getTemplatePresentation();
        presentation.setIcon(null);
        presentation.setText("Troubleshoot device connections");
        return action2;
    }

    public final void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (!this.mySelectDeviceSnapshotComboBoxVisible.get().booleanValue()) {
            presentation.setVisible(false);
            return;
        }
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        presentation.setVisible(true);
        DeviceAndSnapshotComboBoxAction.updatePresentation(presentation, RunManager.getInstance((Project)project).getSelectedConfiguration());
        List<Device> devices = this.getDevices(project);
        devices.sort(new DeviceComparator());
        if (devices.isEmpty()) {
            presentation.setIcon(null);
            presentation.setText("No devices");
            return;
        }
        this.updateSelectedSnapshot(project);
        Device device = this.getSelectedDevice(project);
        assert (device != null);
        presentation.setIcon(device.getIcon());
        String name = Devices.getName(device, devices);
        presentation.setText(this.mySelectedSnapshot == null ? name : name + " - " + this.mySelectedSnapshot, false);
        DeviceAndSnapshotComboBoxAction.updateExecutionTargetManager(project, device);
    }

    @VisibleForTesting
    static void updatePresentation(@NotNull Presentation presentation, @Nullable RunnerAndConfigurationSettings settings) {
        Boolean deploysToLocalDevice;
        if (settings == null) {
            presentation.setDescription("Add a run/debug configuration");
            presentation.setEnabled(false);
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (configuration instanceof UserDataHolder && (deploysToLocalDevice = (Boolean)((UserDataHolder)configuration).getUserData(DEPLOYS_TO_LOCAL_DEVICE)) != null && deploysToLocalDevice.booleanValue()) {
            presentation.setDescription(null);
            presentation.setEnabled(true);
            return;
        }
        if (!(configuration instanceof AndroidRunConfiguration) && !(configuration instanceof AndroidTestRunConfiguration)) {
            presentation.setDescription("Not applicable for the \"" + configuration.getName() + "\" configuration");
            presentation.setEnabled(false);
            return;
        }
        if (configuration instanceof AndroidTestRunConfiguration && DeviceAndSnapshotComboBoxAction.isFirebaseTestLabDeviceMatrixTargetSelected((AndroidRunConfigurationBase)configuration)) {
            presentation.setDescription("Not applicable for the Firebase test lab device matrix target");
            presentation.setEnabled(false);
            return;
        }
        presentation.setDescription(null);
        presentation.setEnabled(true);
    }

    private static boolean isFirebaseTestLabDeviceMatrixTargetSelected(@NotNull AndroidRunConfigurationBase configuration) {
        String id = TargetSelectionMode.FIREBASE_DEVICE_MATRIX.name();
        return configuration.getDeployTargetContext().getCurrentDeployTargetProvider().getId().equals(id);
    }

    private void updateSelectedSnapshot(@NotNull Project project) {
        if (!this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get().booleanValue()) {
            return;
        }
        Device device = this.getSelectedDevice(project);
        assert (device != null);
        Collection<String> snapshots = device.getSnapshots();
        if (this.mySelectedSnapshot == null) {
            Optional<String> selectedDeviceSnapshot = snapshots.stream().findFirst();
            selectedDeviceSnapshot.ifPresent(snapshot -> this.setSelectedSnapshot((String)snapshot));
            return;
        }
        if (snapshots.contains(this.mySelectedSnapshot)) {
            return;
        }
        Optional<String> selectedSnapshot = snapshots.stream().findFirst();
        this.setSelectedSnapshot(selectedSnapshot.orElse(null));
    }

    private static void updateExecutionTargetManager(@NotNull Project project, @Nullable Device device) {
        ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
        if (device == null && target == DefaultExecutionTarget.INSTANCE || target instanceof DeviceAndSnapshotExecutionTargetProvider.Target && Objects.equals(device, ((DeviceAndSnapshotExecutionTargetProvider.Target)target).getDevice())) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings settings = runManager.getSelectedConfiguration();
            if (settings == null || runManager.findSettings(settings.getConfiguration()) == null) {
                return;
            }
            ExecutionTargetManager manager = ExecutionTargetManager.getInstance((Project)project);
            for (ExecutionTarget availableTarget : manager.getTargetsFor(settings.getConfiguration())) {
                if (!(availableTarget instanceof DeviceAndSnapshotExecutionTargetProvider.Target)) continue;
                manager.setActiveTarget(availableTarget);
                break;
            }
        });
    }
}

