/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxDeployableProvider
implements DeployableProvider {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;

    public DeviceAndSnapshotComboBoxDeployableProvider(@NotNull Project project, @NotNull ApplicationIdProvider applicationIdProvider) {
        this.myApplicationIdProvider = applicationIdProvider;
        this.myProject = project;
    }

    @Override
    public boolean isDependentOnUserInput() {
        return false;
    }

    @Override
    @Nullable
    public Deployable getDeployable() throws ApkProvisionException {
        ActionManager manager = ActionManager.getInstance();
        Device device = ((DeviceAndSnapshotComboBoxAction)manager.getAction("DeviceAndSnapshotComboBox")).getSelectedDevice(this.myProject);
        if (device == null) {
            return null;
        }
        return new DeployableDevice(device, this.myApplicationIdProvider.getPackageName());
    }

    private static final class DeployableDevice
    implements Deployable {
        @NotNull
        private final Device myDevice;
        @NotNull
        private final String myPackageName;

        private DeployableDevice(@NotNull Device device, @NotNull String packageName) {
            this.myDevice = device;
            this.myPackageName = packageName;
        }

        @Override
        @NotNull
        public Future<AndroidVersion> getVersion() {
            return this.myDevice.getAndroidVersion();
        }

        @Override
        public boolean isApplicationRunningOnDeployable() {
            return this.myDevice.isRunning(this.myPackageName);
        }

        @Override
        public boolean isOnline() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.isOnline();
        }

        @Override
        public boolean isUnauthorized() {
            IDevice iDevice = this.myDevice.getDdmlibDevice();
            if (iDevice == null) {
                return false;
            }
            return iDevice.getState() == IDevice.DeviceState.UNAUTHORIZED;
        }
    }
}

