/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTarget;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialog;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceAndSnapshotComboBoxTargetProvider
extends DeployTargetProvider {
    @NotNull
    private final Supplier<UISettings> myGetUiSettings;
    @NotNull
    private final Predicate<String> myContainsComboBox;
    private boolean myProvidingMultipleTargets;

    @VisibleForTesting
    public DeviceAndSnapshotComboBoxTargetProvider() {
        this(UISettings::getInstance, DeviceAndSnapshotComboBoxTargetProvider::containsComboBox);
    }

    @VisibleForTesting
    DeviceAndSnapshotComboBoxTargetProvider(@NotNull Supplier<UISettings> getUiSettings, @NotNull Predicate<String> containsComboBox) {
        this.myGetUiSettings = getUiSettings;
        this.myContainsComboBox = containsComboBox;
    }

    @Override
    @NotNull
    public String getId() {
        return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX.name();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Use the device/snapshot drop down";
    }

    @NotNull
    public DeployTargetState createState() {
        return new State();
    }

    @Override
    protected boolean isApplicable(boolean testConfiguration, boolean deviceSnapshotComboBoxVisible) {
        return deviceSnapshotComboBoxVisible;
    }

    @NotNull
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parent, @NotNull DeployTargetConfigurableContext context) {
        return new Configurable();
    }

    @Override
    public boolean requiresRuntimePrompt() {
        return this.myProvidingMultipleTargets || !this.isComboBoxVisible();
    }

    @VisibleForTesting
    boolean isComboBoxVisible() {
        UISettings settings = this.myGetUiSettings.get();
        if (settings.getPresentationMode()) {
            return false;
        }
        if (settings.getShowMainToolbar()) {
            return this.myContainsComboBox.test("MainToolBar");
        }
        if (settings.getShowNavigationBar()) {
            return this.myContainsComboBox.test("NavBarToolBar");
        }
        return false;
    }

    private static boolean containsComboBox(@NotNull String id) {
        ActionGroup group = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(id);
        return ActionUtil.recursiveContainsAction((ActionGroup)group, (AnAction)ActionManager.getInstance().getAction("DeviceAndSnapshotComboBox"));
    }

    void setProvidingMultipleTargets(boolean providingMultipleTargets) {
        this.myProvidingMultipleTargets = providingMultipleTargets;
    }

    @Nullable
    public DeployTarget showPrompt(@NotNull Executor executor, @NotNull ExecutionEnvironment environment, @NotNull AndroidFacet facet, @NotNull DeviceCount count, boolean androidInstrumentedTests, @NotNull Map providerIdToStateMap, int configurationId, @NotNull LaunchCompatibilityChecker checker) {
        assert (this.requiresRuntimePrompt());
        this.myProvidingMultipleTargets = false;
        SelectDeploymentTargetsDialog dialog2 = new SelectDeploymentTargetsDialog(facet.getModule().getProject());
        if (!dialog2.showAndGet()) {
            return null;
        }
        return new DeviceAndSnapshotComboBoxTarget(dialog2.getSelectedDevices());
    }

    @NotNull
    public DeployTarget getDeployTarget() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public DeployTarget getDeployTarget(@NotNull Project project) {
        assert (!this.myProvidingMultipleTargets);
        ActionManager manager = ActionManager.getInstance();
        DeviceAndSnapshotComboBoxAction action2 = (DeviceAndSnapshotComboBoxAction)manager.getAction("DeviceAndSnapshotComboBox");
        Device device = action2.getSelectedDevice(project);
        return new DeviceAndSnapshotComboBoxTarget(device == null ? Collections.emptyList() : Collections.singletonList(device));
    }

    private static final class Configurable
    implements DeployTargetConfigurable {
        private Configurable() {
        }

        @Override
        @Nullable
        public JComponent createComponent() {
            return null;
        }

        public void resetFrom(@NotNull Object state, int id) {
        }

        public void applyTo(@NotNull Object state, int id) {
        }
    }

    @VisibleForTesting
    static final class State
    extends DeployTargetState {
        State() {
        }
    }
}

