/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotExecutionTargetProvider
extends ExecutionTargetProvider {
    @NotNull
    public List<ExecutionTarget> getTargets(@NotNull Project project, @NotNull RunnerAndConfigurationSettings configuration) {
        ActionManager manager = ActionManager.getInstance();
        DeviceAndSnapshotComboBoxAction action2 = (DeviceAndSnapshotComboBoxAction)manager.getAction("DeviceAndSnapshotComboBox");
        if (!((Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get()).booleanValue()) {
            return Collections.singletonList(DefaultExecutionTarget.INSTANCE);
        }
        Device device = action2.getSelectedDevice(project);
        if (device != null) {
            return Collections.singletonList(new Target(device));
        }
        return Collections.singletonList(DefaultExecutionTarget.INSTANCE);
    }

    static class Target
    extends AndroidExecutionTarget {
        @NotNull
        private final Device myDevice;

        private Target(@NotNull Device device) {
            this.myDevice = device;
        }

        @NotNull
        public String getId() {
            return this.myDevice.getKey();
        }

        @NotNull
        public String getDisplayName() {
            return this.myDevice.getName();
        }

        @Nullable
        public Icon getIcon() {
            return this.myDevice.getIcon();
        }

        public boolean canRun(@NotNull RunConfiguration configuration) {
            return true;
        }

        @Override
        public boolean isApplicationRunning(@NotNull String packageName) {
            return this.myDevice.isRunning(packageName);
        }

        @Override
        @Nullable
        public IDevice getIDevice() {
            return this.myDevice.getDdmlibDevice();
        }

        @NotNull
        Device getDevice() {
            return this.myDevice;
        }
    }
}

