/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

final class DeviceComparator
implements Comparator<Device> {
    private static final Comparator<Device> COMPARATOR = Comparator.comparing(Device::isConnected, Comparator.reverseOrder()).thenComparing(Device::isValid, Comparator.reverseOrder()).thenComparing(DeviceComparator::getType).thenComparing(Device::getName);

    DeviceComparator() {
    }

    @NotNull
    private static Type getType(@NotNull Device device) {
        if (device instanceof VirtualDevice) {
            return Type.VIRTUAL_DEVICE;
        }
        if (device instanceof PhysicalDevice) {
            return Type.PHYSICAL_DEVICE;
        }
        throw new AssertionError(device);
    }

    @Override
    public int compare(@NotNull Device device1, @NotNull Device device2) {
        return COMPARATOR.compare(device1, device2);
    }

    private static enum Type {
        VIRTUAL_DEVICE,
        PHYSICAL_DEVICE;

    }
}

