/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.google.common.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class KeyToConnectionTimeMap {
    private final Map<String, Instant> myMap = new HashMap<String, Instant>();
    private final Clock myClock;

    KeyToConnectionTimeMap() {
        this(Clock.systemDefaultZone());
    }

    @VisibleForTesting
    KeyToConnectionTimeMap(@NotNull Clock clock) {
        this.myClock = clock;
    }

    @NotNull
    Instant get(@NotNull String key) {
        return this.myMap.computeIfAbsent(key, k -> this.myClock.instant());
    }

    void retainAll(@NotNull Collection<String> keys) {
        this.myMap.keySet().retainAll(keys);
    }
}

