/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RunOnMultipleDevicesAction
extends AnAction {
    @NotNull
    private final Function<Project, RunnerAndConfigurationSettings> myGetSelectedConfiguration;

    RunOnMultipleDevicesAction() {
        this(project -> RunManager.getInstance((Project)project).getSelectedConfiguration());
    }

    @VisibleForTesting
    RunOnMultipleDevicesAction(@NotNull Function<Project, RunnerAndConfigurationSettings> getSelectedConfiguration) {
        super("Run on multiple devices", null, AllIcons.Actions.Execute);
        this.myGetSelectedConfiguration = getSelectedConfiguration;
    }

    public void update(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        Presentation presentation = event.getPresentation();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        RunnerAndConfigurationSettings settings = this.myGetSelectedConfiguration.apply(project);
        if (settings == null) {
            presentation.setEnabled(false);
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (!(configuration instanceof AndroidRunConfiguration)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        DeviceAndSnapshotComboBoxTargetProvider provider = RunOnMultipleDevicesAction.findProvider();
        if (provider == null) {
            return;
        }
        provider.setProvidingMultipleTargets(true);
        ExecutionEnvironmentBuilder builder = RunOnMultipleDevicesAction.createBuilder(event.getDataContext());
        if (builder == null) {
            return;
        }
        ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
    }

    @Nullable
    private static DeviceAndSnapshotComboBoxTargetProvider findProvider() {
        Optional<DeployTargetProvider> optionalProvider = DeployTargetProvider.getProviders().stream().filter(DeviceAndSnapshotComboBoxTargetProvider.class::isInstance).findFirst();
        return optionalProvider.orElse(null);
    }

    @Nullable
    private static ExecutionEnvironmentBuilder createBuilder(@NotNull DataContext context) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById("Run");
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            return null;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            return null;
        }
        builder.dataContext(context);
        return builder;
    }
}

