/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialogTable;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialogTableModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Collection;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectDeploymentTargetsDialog
extends DialogWrapper {
    @Nullable
    private SelectDeploymentTargetsDialogTable myTable;

    SelectDeploymentTargetsDialog(@NotNull Project project) {
        super(project);
        this.initTable(project);
        this.init();
        this.setTitle("Select Deployment Targets");
    }

    private void initTable(@NotNull Project project) {
        SelectDeploymentTargetsDialogTableModel model2 = new SelectDeploymentTargetsDialogTableModel(project);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)model2);
        this.myTable = new SelectDeploymentTargetsDialogTable(model2);
        this.myTable.getSelectionModel().addListSelectionListener(event -> this.getOKAction().setEnabled(this.myTable.getSelectedRowCount() != 0));
    }

    @NotNull
    Collection<Device> getSelectedDevices() {
        assert (this.myTable != null);
        return this.myTable.getSelectedDevices();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        GroupLayout layout2 = new GroupLayout(panel2);
        JLabel label = new JLabel("Available devices");
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.myTable));
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(label).addComponent((Component)scrollPane);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(label).addComponent((Component)scrollPane);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        return panel2;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
        this.myOKAction.putValue("Name", "Run");
    }
}

