/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.BooleanTableCellEditor;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.SelectDeploymentTargetsDialogTableModel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

final class SelectDeploymentTargetsDialogTable
extends JBTable {
    SelectDeploymentTargetsDialogTable(@NotNull SelectDeploymentTargetsDialogTableModel model2) {
        super((TableModel)model2);
        this.getTableHeader().setResizingAllowed(false);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor());
        this.setRowHeight(JBUI.scale((int)30));
        model2.addTableModelListener(this::synchronizeRowSelectionWithSelectedColumn);
        model2.addTableModelListener(event -> this.setSelectedAndIconColumnMaxWidthsToFit());
        this.getSelectionModel().addListSelectionListener(event -> this.synchronizeSelectedColumnWithRowSelection());
    }

    private void synchronizeRowSelectionWithSelectedColumn(@NotNull TableModelEvent event) {
        int viewColumnIndex;
        int modelColumnIndex = event.getColumn();
        if (modelColumnIndex != 0) {
            return;
        }
        int viewRowIndex = this.convertRowIndexToView(event.getFirstRow());
        if (((Boolean)this.getValueAt(viewRowIndex, viewColumnIndex = this.convertColumnIndexToView(modelColumnIndex))).booleanValue()) {
            this.getSelectionModel().addSelectionInterval(viewRowIndex, viewRowIndex);
            return;
        }
        this.getSelectionModel().removeSelectionInterval(viewRowIndex, viewRowIndex);
    }

    private void setSelectedAndIconColumnMaxWidthsToFit() {
        this.setMaxWidthToFit(this.convertColumnIndexToView(0));
        this.setMaxWidthToFit(this.convertColumnIndexToView(1));
    }

    private void setMaxWidthToFit(int viewColumnIndex) {
        OptionalInt maxPreferredWidth = IntStream.range(-1, this.getRowCount()).map(viewRowIndex -> this.getPreferredWidth(viewRowIndex, viewColumnIndex)).max();
        maxPreferredWidth.ifPresent(this.getColumnModel().getColumn(viewColumnIndex)::setMaxWidth);
    }

    private int getPreferredWidth(int viewRowIndex, int viewColumnIndex) {
        Component component;
        if (viewRowIndex == -1) {
            String name = this.getColumnName(viewColumnIndex);
            component = this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)((Object)this), name, false, false, -1, viewColumnIndex);
        } else {
            component = this.prepareRenderer(this.getCellRenderer(viewRowIndex, viewColumnIndex), viewRowIndex, viewColumnIndex);
        }
        return component.getPreferredSize().width + JBUI.scale((int)8);
    }

    private void synchronizeSelectedColumnWithRowSelection() {
        SelectDeploymentTargetsDialogTableModel model2 = (SelectDeploymentTargetsDialogTableModel)this.getModel();
        IntStream.range(0, this.getRowCount()).forEach(viewRowIndex -> model2.setSelected(this.isRowSelected(viewRowIndex), this.convertRowIndexToModel(viewRowIndex)));
    }

    @NotNull
    Collection<Device> getSelectedDevices() {
        SelectDeploymentTargetsDialogTableModel model2 = (SelectDeploymentTargetsDialogTableModel)this.getModel();
        return Arrays.stream(this.getSelectedRows()).map(arg_0 -> this.convertRowIndexToModel(arg_0)).mapToObj(model2::getDeviceAt).collect(Collectors.toList());
    }
}

