/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.Devices;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectDeploymentTargetsDialogTableModel
extends AbstractTableModel
implements Disposable {
    static final int SELECTED_MODEL_COLUMN_INDEX = 0;
    static final int ICON_MODEL_COLUMN_INDEX = 1;
    private static final int NAME_MODEL_COLUMN_INDEX = 2;
    @NotNull
    private List<Boolean> mySelected = Collections.emptyList();
    @NotNull
    private List<Device> myDevices = Collections.emptyList();
    @Nullable
    private Timer myTimer = new Timer(1000, event -> {
        if (project.isDisposed()) {
            return;
        }
        int oldDeviceCount = this.myDevices.size();
        this.myDevices = ((AsyncDevicesGetter)ServiceManager.getService((Project)project, AsyncDevicesGetter.class)).get();
        this.myDevices.sort(new DeviceComparator());
        int newDeviceCount = this.myDevices.size();
        if (oldDeviceCount != newDeviceCount) {
            this.mySelected = new ArrayList<Boolean>(Collections.nCopies(newDeviceCount, false));
            this.fireTableDataChanged();
            return;
        }
        this.fireTableRowsUpdated(0, newDeviceCount - 1);
    });

    SelectDeploymentTargetsDialogTableModel(@NotNull Project project) {
        this.myTimer.setInitialDelay(0);
        this.myTimer.start();
    }

    public void dispose() {
        assert (this.myTimer != null);
        this.myTimer.stop();
        this.myTimer = null;
    }

    @NotNull
    Device getDeviceAt(int modelRowIndex) {
        return this.myDevices.get(modelRowIndex);
    }

    @Override
    public int getRowCount() {
        return this.myDevices.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Device name";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Icon.class;
            }
            case 2: {
                return Object.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.mySelected.get(modelRowIndex);
            }
            case 1: {
                return this.myDevices.get(modelRowIndex).getIcon();
            }
            case 2: {
                return Devices.getName(this.myDevices.get(modelRowIndex), this.myDevices);
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public void setValueAt(@NotNull Object value2, int modelRowIndex, int modelColumnIndex) {
        this.mySelected.set(modelRowIndex, (Boolean)value2);
        this.fireTableCellUpdated(modelRowIndex, modelColumnIndex);
    }

    void setSelected(boolean selected, int modelRowIndex) {
        this.mySelected.set(modelRowIndex, selected);
    }
}

