/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectDeviceAndSnapshotAction
extends AnAction {
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;
    private final Project myProject;
    private final Device myDevice;
    private String mySnapshot;

    private SelectDeviceAndSnapshotAction(@NotNull Builder builder) {
        this.configurePresentation(builder);
        this.myComboBoxAction = builder.myComboBoxAction;
        this.myProject = builder.myProject;
        this.myDevice = builder.myDevice;
        this.initSnapshot(builder);
    }

    private void configurePresentation(@NotNull Builder builder) {
        Presentation presentation = this.getTemplatePresentation();
        if (builder.mySnapshot != null) {
            presentation.setText(builder.mySnapshot, false);
            return;
        }
        presentation.setText(Devices.getName(builder.myDevice, builder.myComboBoxAction.getDevices(builder.myProject)), false);
        presentation.setIcon(builder.myDevice.getIcon());
    }

    private void initSnapshot(@NotNull Builder builder) {
        if (builder.mySnapshot != null) {
            this.mySnapshot = builder.mySnapshot;
            return;
        }
        Collection<String> snapshots = builder.myDevice.getSnapshots();
        if (snapshots.isEmpty() || !builder.myComboBoxAction.areSnapshotsEnabled()) {
            this.mySnapshot = null;
            return;
        }
        if (snapshots.equals(VirtualDevice.DEFAULT_SNAPSHOT_COLLECTION)) {
            this.mySnapshot = "default_boot";
            return;
        }
        throw new IllegalArgumentException(builder.toString());
    }

    @Nullable
    @VisibleForTesting
    String getSnapshot() {
        return this.mySnapshot;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        this.myComboBoxAction.setSelectedDevice(this.myProject, this.myDevice);
        this.myComboBoxAction.setSelectedSnapshot(this.mySnapshot);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SelectDeviceAndSnapshotAction)) {
            return false;
        }
        SelectDeviceAndSnapshotAction action2 = (SelectDeviceAndSnapshotAction)((Object)object);
        return ((Object)((Object)this.myComboBoxAction)).equals((Object)action2.myComboBoxAction) && this.myProject.equals(action2.myProject) && this.myDevice.equals(action2.myDevice) && Objects.equals(this.mySnapshot, action2.mySnapshot);
    }

    public int hashCode() {
        int hashCode = ((Object)((Object)this.myComboBoxAction)).hashCode();
        hashCode = 31 * hashCode + this.myProject.hashCode();
        hashCode = 31 * hashCode + this.myDevice.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mySnapshot);
        return hashCode;
    }

    static final class Builder {
        private DeviceAndSnapshotComboBoxAction myComboBoxAction;
        private Project myProject;
        private Device myDevice;
        private String mySnapshot;

        Builder() {
        }

        @NotNull
        Builder setComboBoxAction(@NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
            this.myComboBoxAction = comboBoxAction;
            return this;
        }

        @NotNull
        Builder setProject(@NotNull Project project) {
            this.myProject = project;
            return this;
        }

        @NotNull
        Builder setDevice(@NotNull Device device) {
            this.myDevice = device;
            return this;
        }

        @NotNull
        Builder setSnapshot(@Nullable String snapshot) {
            this.mySnapshot = snapshot;
            return this;
        }

        @NotNull
        SelectDeviceAndSnapshotAction build() {
            return new SelectDeviceAndSnapshotAction(this);
        }
    }
}

