/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.SelectDeviceAndSnapshotAction;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SnapshotActionGroup
extends ActionGroup {
    private final Device myDevice;
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;
    private final Project myProject;

    SnapshotActionGroup(@NotNull VirtualDevice device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, @NotNull Project project) {
        super(device.getName(), null, device.getIcon());
        this.setPopup(true);
        this.myDevice = device;
        this.myComboBoxAction = comboBoxAction;
        this.myProject = project;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent event) {
        return (AnAction[])this.myDevice.getSnapshots().stream().map(this::newSelectDeviceAndSnapshotAction).toArray(AnAction[]::new);
    }

    @NotNull
    private AnAction newSelectDeviceAndSnapshotAction(@NotNull String snapshot) {
        return new SelectDeviceAndSnapshotAction.Builder().setComboBoxAction(this.myComboBoxAction).setProject(this.myProject).setDevice(this.myDevice).setSnapshot(snapshot).build();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SnapshotActionGroup)) {
            return false;
        }
        SnapshotActionGroup group = (SnapshotActionGroup)((Object)object);
        return this.myDevice.equals(group.myDevice) && ((Object)((Object)this.myComboBoxAction)).equals((Object)group.myComboBoxAction) && this.myProject.equals(group.myProject);
    }

    public int hashCode() {
        int hashCode = this.myDevice.hashCode();
        hashCode = 31 * hashCode + ((Object)((Object)this.myComboBoxAction)).hashCode();
        hashCode = 31 * hashCode + this.myProject.hashCode();
        return hashCode;
    }
}

