/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevice
extends Device {
    static final String DEFAULT_SNAPSHOT = "default_boot";
    static final ImmutableCollection<String> DEFAULT_SNAPSHOT_COLLECTION = ImmutableList.of((Object)"default_boot");
    private static final Icon ourConnectedIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE);
    @NotNull
    private final ImmutableCollection<String> mySnapshots;

    @NotNull
    static VirtualDevice newConnectedDevice(@NotNull VirtualDevice virtualDevice, @NotNull ConnectedDevice connectedDevice, @NotNull KeyToConnectionTimeMap map2) {
        String key = virtualDevice.getKey();
        return new Builder().setName(virtualDevice.getName()).setValid(connectedDevice.isValid()).setValidityReason(connectedDevice.getValidityReason()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(connectedDevice.getAndroidDevice()).setSnapshots(virtualDevice.mySnapshots).build();
    }

    private VirtualDevice(@NotNull Builder builder) {
        super(builder);
        this.mySnapshots = builder.mySnapshots;
    }

    @Override
    @NotNull
    Icon getIcon() {
        return this.isConnected() ? ourConnectedIcon : StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
    }

    @Override
    boolean isConnected() {
        return this.getConnectionTime() != null;
    }

    @NotNull
    ImmutableCollection<String> getSnapshots() {
        return this.mySnapshots;
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        AndroidDevice androidDevice = this.getAndroidDevice();
        if (androidDevice instanceof LaunchableAndroidDevice) {
            return Futures.immediateFuture((Object)((LaunchableAndroidDevice)androidDevice).getAvdInfo().getAndroidVersion());
        }
        IDevice ddmlibDevice = this.getDdmlibDevice();
        assert (ddmlibDevice != null);
        return DeploymentApplicationService.getInstance().getVersion(ddmlibDevice);
    }

    @Override
    void addTo(@NotNull DeviceFutures futures, @NotNull Project project, @Nullable String snapshot) {
        AndroidDevice device = this.getAndroidDevice();
        if (!this.isConnected()) {
            device.launch(project, snapshot);
        }
        futures.getDevices().add(device);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof VirtualDevice)) {
            return false;
        }
        VirtualDevice device = (VirtualDevice)object;
        return this.getName().equals(device.getName()) && this.isValid() == device.isValid() && Objects.equals(this.getValidityReason(), device.getValidityReason()) && this.getKey().equals(device.getKey()) && Objects.equals(this.getConnectionTime(), device.getConnectionTime()) && this.getAndroidDevice().equals(device.getAndroidDevice()) && this.mySnapshots.equals(device.mySnapshots);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isValid(), this.getValidityReason(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice(), this.mySnapshots);
    }

    static final class Builder
    extends Device.Builder {
        @NotNull
        private ImmutableCollection<String> mySnapshots = ImmutableList.of();

        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setValid(boolean valid) {
            this.myValid = valid;
            return this;
        }

        @NotNull
        Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            return this;
        }

        @NotNull
        Builder setKey(@NotNull String key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        Builder setSnapshots(@NotNull ImmutableCollection<String> snapshots) {
            this.mySnapshots = snapshots;
            return this;
        }

        @Override
        @NotNull
        VirtualDevice build() {
            return new VirtualDevice(this);
        }
    }
}

