/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.emulator.SnapshotOuterClass;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.WorkerDelegate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicesWorkerDelegate
extends WorkerDelegate<Collection<VirtualDevice>> {
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    VirtualDevicesWorkerDelegate(@Nullable LaunchCompatibilityChecker checker) {
        super(Collections.emptyList());
        this.myChecker = checker;
    }

    @Override
    @NotNull
    public Collection<VirtualDevice> construct() {
        return AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(false).stream().map(this::newDisconnectedDevice).collect(Collectors.toList());
    }

    @NotNull
    private VirtualDevice newDisconnectedDevice(@NotNull AvdInfo avdInfo) {
        LaunchableAndroidDevice device = new LaunchableAndroidDevice(avdInfo);
        VirtualDevice.Builder builder = new VirtualDevice.Builder().setName(AvdManagerConnection.getAvdDisplayName(avdInfo)).setKey(avdInfo.getName()).setAndroidDevice(device).setSnapshots(VirtualDevicesWorkerDelegate.getSnapshots(avdInfo));
        if (this.myChecker == null) {
            return builder.build();
        }
        LaunchCompatibility compatibility = this.myChecker.validate(device);
        return builder.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ImmutableCollection<String> getSnapshots(@NotNull AvdInfo avdInfo) {
        Path snapshots = Paths.get(avdInfo.getDataFolderPath(), "snapshots");
        if (!Files.isDirectory(snapshots, new LinkOption[0])) {
            return ImmutableList.of();
        }
        try (Stream<Path> stream = Files.list(snapshots);){
            Collector collector = ImmutableList.toImmutableList();
            ImmutableCollection immutableCollection = (ImmutableCollection)stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(VirtualDevicesWorkerDelegate::getName).filter(Objects::nonNull).sorted().collect(collector);
            return immutableCollection;
        }
        catch (IOException exception) {
            Logger.getInstance(VirtualDevicesWorkerDelegate.class).warn(snapshots.toString(), (Throwable)exception);
            return ImmutableList.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @VisibleForTesting
    static String getName(@NotNull Path snapshotDirectory) {
        Path snapshotProtocolBuffer = snapshotDirectory.resolve("snapshot.pb");
        String snapshotDirectoryName = snapshotDirectory.getFileName().toString();
        if (!Files.exists(snapshotProtocolBuffer, new LinkOption[0])) {
            return snapshotDirectoryName;
        }
        try (InputStream in = Files.newInputStream(snapshotProtocolBuffer, new OpenOption[0]);){
            String string = VirtualDevicesWorkerDelegate.getName(SnapshotOuterClass.Snapshot.parseFrom(in), snapshotDirectoryName);
            return string;
        }
        catch (IOException exception) {
            Logger.getInstance(VirtualDevicesWorkerDelegate.class).warn(snapshotDirectory.toString(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    static String getName(@NotNull SnapshotOuterClass.Snapshot snapshot, @NotNull String fallbackName) {
        if (snapshot.getImagesCount() == 0) {
            return null;
        }
        String name = snapshot.getLogicalName();
        if (name.isEmpty()) {
            return fallbackName;
        }
        return name;
    }
}

