/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.ImmutableSortedMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebuggerContext
implements JDOMExternalizable {
    public String DEBUGGER_TYPE;
    private final Map<String, AndroidDebuggerState> myAndroidDebuggerStates;
    private final String myDefaultDebuggerType;

    public AndroidDebuggerContext(@NotNull String defaultDebuggerType) {
        this.myDefaultDebuggerType = defaultDebuggerType;
        this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            builder.put((Object)androidDebugger.getId(), androidDebugger.createState());
        }
        this.myAndroidDebuggerStates = builder.build();
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = element.getChild(entry.getKey());
            if (optionElement == null) continue;
            entry.getValue().readExternal(optionElement);
        }
        if (this.getAndroidDebugger() == null) {
            this.DEBUGGER_TYPE = this.getDefaultAndroidDebuggerType();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (Map.Entry<String, AndroidDebuggerState> entry : this.myAndroidDebuggerStates.entrySet()) {
            Element optionElement = new Element(entry.getKey());
            element.addContent(optionElement);
            entry.getValue().writeExternal(optionElement);
        }
    }

    @NotNull
    public String getDebuggerType() {
        return this.DEBUGGER_TYPE;
    }

    public void setDebuggerType(@NotNull String debuggerType) {
        this.DEBUGGER_TYPE = debuggerType;
    }

    @NotNull
    public List<AndroidDebugger> getAndroidDebuggers() {
        return AndroidDebugger.EP_NAME.getExtensionList();
    }

    @Nullable
    public AndroidDebugger getAndroidDebugger() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.getId().equals(this.DEBUGGER_TYPE)) continue;
            return androidDebugger;
        }
        return null;
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState(@NotNull String androidDebuggerId) {
        AndroidDebuggerState state = this.myAndroidDebuggerStates.get(androidDebuggerId);
        return (T)(state != null ? state : null);
    }

    @Nullable
    public <T extends AndroidDebuggerState> T getAndroidDebuggerState() {
        return this.getAndroidDebuggerState(this.DEBUGGER_TYPE);
    }

    public void setDebuggeeModule(@Nullable Module module) {
        for (AndroidDebuggerState state : this.myAndroidDebuggerStates.values()) {
            state.setDebuggeeModule(module);
        }
    }

    @NotNull
    protected String getDefaultAndroidDebuggerType() {
        for (AndroidDebugger androidDebugger : this.getAndroidDebuggers()) {
            if (!androidDebugger.shouldBeDefault()) continue;
            return androidDebugger.getId();
        }
        return this.myDefaultDebuggerType;
    }
}

