/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidDebuggerImplBase<S extends AndroidDebuggerState>
implements AndroidDebugger<S> {
    private Set<XBreakpointType<?, ?>> mySupportedBreakpointTypes;
    private final Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses;

    protected AndroidDebuggerImplBase(Set<Class<? extends XBreakpointType<?, ?>>> breakpointTypeClasses) {
        this.breakpointTypeClasses = breakpointTypeClasses;
    }

    @NotNull
    protected static String getClientDebugPort(@NotNull Client client) {
        return Integer.toString(client.getDebuggerListenPort()).trim();
    }

    @Nullable
    protected static DebuggerSession findJdwpDebuggerSession(@NotNull Project project, @NotNull String debugPort) {
        for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            if (!debugPort.equals(session.getProcess().getConnection().getAddress().trim())) continue;
            return session;
        }
        return null;
    }

    protected static boolean activateDebugSessionWindow(@NotNull Project project, @NotNull RunContentDescriptor descriptor2) {
        ProcessHandler processHandler = descriptor2.getProcessHandler();
        Content content = descriptor2.getAttachedContent();
        if (processHandler == null || content == null) {
            return false;
        }
        Executor executor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (processHandler.isProcessTerminated()) {
            ExecutionManager.getInstance((Project)project).getContentManager().removeRunContent(executor, descriptor2);
            return false;
        }
        content.getManager().setSelectedContent(content);
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(executor.getToolWindowId());
        window.activate(null, false, true);
        return true;
    }

    @Override
    @NotNull
    public synchronized Set<XBreakpointType<?, ?>> getSupportedBreakpointTypes(@NotNull Project project, @NotNull AndroidVersion version2) {
        if (this.mySupportedBreakpointTypes == null) {
            XDebuggerUtil debuggerUtil = XDebuggerUtil.getInstance();
            this.mySupportedBreakpointTypes = Sets.newHashSet();
            for (Class<? extends XBreakpointType<?, ?>> clazz : this.breakpointTypeClasses) {
                this.mySupportedBreakpointTypes.add(debuggerUtil.findBreakpointType(clazz));
            }
        }
        return this.mySupportedBreakpointTypes;
    }

    @Override
    public boolean shouldBeDefault() {
        return false;
    }

    @Override
    @NotNull
    public String getAmStartOptions(@NotNull S state, @NotNull Project project, @NotNull AndroidVersion version2) {
        return "";
    }
}

