/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.annotations.concurrency.Slow;
import com.android.builder.model.TestOptions;
import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerImplBase;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.tasks.AndroidTestOrchestratorJavaDebuggerTask;
import com.android.tools.idea.run.tasks.ConnectJavaDebuggerTask;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDebugger
extends AndroidDebuggerImplBase<AndroidDebuggerState> {
    public static final String ID = "Java";
    private static final String RUN_CONFIGURATION_NAME_PATTERN = "Android Debugger (%s)";
    public static final Set<Class<? extends XBreakpointType<?, ?>>> JAVA_BREAKPOINT_TYPES = ImmutableSet.of(JavaLineBreakpointType.class, JavaMethodBreakpointType.class, JavaFieldBreakpointType.class);

    public AndroidJavaDebugger() {
        super(JAVA_BREAKPOINT_TYPES);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    @NotNull
    public AndroidDebuggerState createState() {
        return new AndroidDebuggerState();
    }

    @Override
    @NotNull
    public AndroidDebuggerConfigurable<AndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new AndroidDebuggerConfigurable<AndroidDebuggerState>();
    }

    @Override
    @NotNull
    public DebugConnectorTask getConnectDebuggerTask(@NotNull ExecutionEnvironment env, @Nullable AndroidVersion version2, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull AndroidDebuggerState state, @NotNull String runConfigTypeId, boolean monitorRemoteProcess) {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        if (androidModuleModel != null && TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.equals((Object)androidModuleModel.getTestExecutionStrategy())) {
            return new AndroidTestOrchestratorJavaDebuggerTask(applicationIds, this, env.getProject(), monitorRemoteProcess);
        }
        return new ConnectJavaDebuggerTask(applicationIds, this, env.getProject(), monitorRemoteProcess, ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4);
    }

    @Override
    public boolean supportsProject(@NotNull Project project) {
        return true;
    }

    @Override
    @Slow
    public void attachToClient(@NotNull Project project, @NotNull Client client) {
        String debugPort = AndroidJavaDebugger.getClientDebugPort(client);
        String runConfigName = String.format(RUN_CONFIGURATION_NAME_PATTERN, debugPort);
        Ref existingSession = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> existingSession.set((Object)AndroidJavaDebugger.hasExistingDebugSession(project, debugPort, runConfigName)));
        if (((Boolean)existingSession.get()).booleanValue()) {
            return;
        }
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(runConfigName, RemoteConfigurationType.class);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = false;
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
    }

    public DebuggerSession getDebuggerSession(@NotNull Client client) {
        String debugPort = AndroidJavaDebugger.getClientDebugPort(client);
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            DebuggerSession debuggerSession = AndroidJavaDebugger.findJdwpDebuggerSession(openProject, debugPort);
            if (debuggerSession == null) continue;
            return debuggerSession;
        }
        return null;
    }

    private static boolean hasExistingDebugSession(@NotNull Project project, @NotNull String debugPort, final @NotNull String runConfigName) {
        Project[] openProjects;
        Collection<Object> descriptors = null;
        for (Project openProject : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            DebuggerSession debuggerSession;
            Project targetProject = openProject;
            descriptors = ExecutionHelper.findRunningConsoleByTitle((Project)targetProject, (NotNullFunction)new NotNullFunction<String, Boolean>(){

                @NotNull
                public Boolean fun(String title) {
                    return runConfigName.equals(title);
                }
            });
            if (descriptors.isEmpty() && (debuggerSession = AndroidJavaDebugger.findJdwpDebuggerSession(targetProject, debugPort)) != null) {
                XDebugSession session = debuggerSession.getXDebugSession();
                if (session != null) {
                    descriptors = Collections.singletonList(session.getRunContentDescriptor());
                } else {
                    debuggerSession.getProcess().stop(false);
                }
            }
            if (!descriptors.isEmpty()) break;
        }
        if (descriptors != null && !descriptors.isEmpty()) {
            return AndroidJavaDebugger.activateDebugSessionWindow(project, (RunContentDescriptor)descriptors.iterator().next());
        }
        return false;
    }
}

