/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.Future;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class AndroidProfilersPanel
implements HyperlinkListener {
    private static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.4.0";
    private static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.4.0");
    private final Project myProject;
    private JPanel myDescription;
    private JCheckBox myAdvancedProfilingCheckBox;
    private ClickableLabel myAdvancedProfilingLabel;
    private HyperlinkLabel myHyperlinkLabel;
    private JTextPane myAdvancedProfilingDescription;
    private JLabel mySyncStatusMessage;
    private JCheckBox myStartupCpuProfileCheckBox;
    private ClickableLabel myStartupCpuProfileLabel;
    private ComboBox<CpuProfilerConfig> myStartupCpuConfigsComboBox;
    private JTextPane myStartupCpuProfilerDescription;

    public JComponent getComponent() {
        return this.myDescription;
    }

    AndroidProfilersPanel(Project project, ProfilerState state) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.updateHyperlink("");
        this.addActionListenersToLabels();
        this.setUpStartupCpuProfiling();
        this.resetFrom(state);
    }

    void addActionListenersToLabels() {
        this.myAdvancedProfilingLabel.addActionListener(e -> {
            this.myAdvancedProfilingCheckBox.requestFocus();
            this.myAdvancedProfilingCheckBox.setSelected(!this.myAdvancedProfilingCheckBox.isSelected());
        });
        this.myStartupCpuProfileLabel.addActionListener(e -> {
            this.myStartupCpuProfileCheckBox.requestFocus();
            this.myStartupCpuProfileCheckBox.setSelected(!this.myStartupCpuProfileCheckBox.isSelected());
        });
    }

    private void setUpStartupCpuProfiling() {
        this.myStartupCpuProfileCheckBox.addItemListener(e -> this.myStartupCpuConfigsComboBox.setEnabled(this.myStartupCpuProfileCheckBox.isSelected()));
        this.myStartupCpuConfigsComboBox.setEnabled(this.myStartupCpuProfileCheckBox.isSelected());
        this.myStartupCpuConfigsComboBox.setModel(new DefaultComboBoxModel<CpuProfilerConfig>(CpuProfilerConfigsState.getInstance(this.myProject).getConfigs().toArray(new CpuProfilerConfig[0])));
        this.myStartupCpuConfigsComboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<CpuProfilerConfig>(){

            protected void customizeCellRenderer(@NotNull JList<? extends CpuProfilerConfig> list, CpuProfilerConfig value2, int index, boolean selected, boolean hasFocus) {
                this.append(value2.getName());
            }
        });
        this.myStartupCpuConfigsComboBox.setSelectedIndex(0);
        if (!((Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get()).booleanValue()) {
            this.myStartupCpuProfileCheckBox.setVisible(false);
            this.myStartupCpuProfileLabel.setVisible(false);
            this.myStartupCpuConfigsComboBox.setVisible(false);
            this.myStartupCpuProfilerDescription.setVisible(false);
        }
    }

    void resetFrom(ProfilerState state) {
        boolean enabled = this.myAdvancedProfilingCheckBox.isEnabled();
        this.myAdvancedProfilingDescription.setBackground(this.myDescription.getBackground());
        this.myAdvancedProfilingCheckBox.setSelected(enabled && state.ADVANCED_PROFILING_ENABLED);
        this.myStartupCpuProfileCheckBox.setSelected(state.STARTUP_CPU_PROFILING_ENABLED);
        this.myStartupCpuProfilerDescription.setBackground(this.myDescription.getBackground());
        String name = state.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig config = CpuProfilerConfigsState.getInstance(this.myProject).getConfigByName(name);
        if (config != null) {
            this.myStartupCpuConfigsComboBox.setSelectedItem((Object)config);
        }
    }

    void applyTo(ProfilerState state) {
        state.ADVANCED_PROFILING_ENABLED = this.myAdvancedProfilingCheckBox.isSelected();
        boolean bl = state.STARTUP_CPU_PROFILING_ENABLED = (Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get() != false && this.myStartupCpuProfileCheckBox.isSelected();
        assert (this.myStartupCpuConfigsComboBox.getSelectedItem() instanceof CpuProfilerConfig);
        state.STARTUP_CPU_PROFILING_CONFIGURATION_NAME = ((CpuProfilerConfig)this.myStartupCpuConfigsComboBox.getSelectedItem()).getName();
    }

    private void createUIComponents() {
        this.myHyperlinkLabel = new HyperlinkLabel();
        this.myHyperlinkLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void updateHyperlink(String message2) {
        boolean supported = true;
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) continue;
            GradleVersion modelVersion = model2.getModelVersion();
            boolean bl = supported = modelVersion != null && modelVersion.compareIgnoringQualifiers(MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
            if (!supported) break;
        }
        this.myHyperlinkLabel.setHyperlinkText("This feature can only be enabled with a gradle plugin version of 2.4 or greater. ", "Update project", "");
        this.myHyperlinkLabel.setVisible(!supported);
        this.mySyncStatusMessage.setText(message2);
        this.myHyperlinkLabel.setVisible(!supported);
        this.myDescription.setEnabled(supported);
        this.myAdvancedProfilingCheckBox.setEnabled(supported);
        this.myAdvancedProfilingLabel.setEnabled(supported);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"5.4.1");
        GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        if (MINIMUM_GRADLE_PLUGIN_VERSION.compareIgnoringQualifiers(pluginVersion) > 0) {
            this.updateHyperlink("(No matching gradle version found)");
            return;
        }
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(this.myProject);
        AndroidPluginVersionUpdater.UpdateResult result2 = updater.updatePluginVersion(pluginVersion, gradleVersion2);
        if (result2.isPluginVersionUpdated() && result2.versionUpdateSuccess()) {
            this.requestSync();
        } else {
            this.updateHyperlink("(Update failed)");
        }
    }

    private void requestSync() {
        SettableFuture syncResult = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.updateHyperlink("(Syncing...)");
            syncResult.setFuture(ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true));
        });
        if (((ProjectSystemSyncManager.SyncResult)((Object)Futures.getUnchecked((Future)syncResult))).isSuccessful()) {
            this.updateHyperlink("");
        } else {
            this.updateHyperlink("(Sync failed)");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JTextPane jTextPane;
        ClickableLabel clickableLabel;
        JCheckBox jCheckBox;
        JTextPane jTextPane2;
        ClickableLabel clickableLabel2;
        JLabel jLabel;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myDescription = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myAdvancedProfilingCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setAlignmentX(1.0f);
        jCheckBox2.setHorizontalAlignment(4);
        jCheckBox2.setHorizontalTextPosition(4);
        jCheckBox2.setIconTextGap(0);
        jCheckBox2.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox2.setText("");
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        HyperlinkLabel hyperlinkLabel = this.myHyperlinkLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(5, 0, 1, 3, 9, 0, 7, 3, null, new Dimension(150, 20), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.mySyncStatusMessage = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(6, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myAdvancedProfilingLabel = clickableLabel2 = new ClickableLabel();
        clickableLabel2.setText("Enable advanced profiling (required for API level < 26 only)");
        jPanel.add((Component)clickableLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdvancedProfilingDescription = jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        ((Component)jTextPane2).setForeground(new Color(-11645362));
        jTextPane2.setText("Allows the profilers to track data such as network payloads, application events and object counts, but it might have a minor performance impact on your build speeds. ");
        jPanel.add((Component)jTextPane2, new GridConstraints(1, 1, 1, 1, 0, 3, 6, 2, null, new Dimension(150, 50), null));
        this.myStartupCpuProfileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(4);
        jCheckBox.setHorizontalTextPosition(4);
        jCheckBox.setIconTextGap(0);
        jCheckBox.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        this.myStartupCpuProfileLabel = clickableLabel = new ClickableLabel();
        clickableLabel.setText("Start recording CPU activity on startup");
        jPanel.add((Component)clickableLabel, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartupCpuProfilerDescription = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        ((Component)jTextPane).setForeground(new Color(-11645362));
        jTextPane.setText("You must select Run > Profile from the main menu and deploy your app to a device running Android 8.0 (API level 26) or higher.");
        jPanel.add((Component)jTextPane, new GridConstraints(3, 1, 1, 1, 0, 3, 1, 1, null, new Dimension(150, 10), null));
        this.myStartupCpuConfigsComboBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(4, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(42, 33), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myDescription;
    }
}

