/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.executors.DefaultRunExecutor;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChooserDeployableProvider
implements DeployableProvider {
    @NotNull
    private final AndroidRunConfigurationBase myAndroidRunConfigurationBase;
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ShowChooserTargetProvider myTargetProvider;

    public ChooserDeployableProvider(@NotNull AndroidRunConfigurationBase androidRunConfigurationBase, @NotNull AndroidFacet androidFacet, @NotNull ShowChooserTargetProvider targetProvider) {
        this.myAndroidRunConfigurationBase = androidRunConfigurationBase;
        this.myAndroidFacet = androidFacet;
        this.myTargetProvider = targetProvider;
    }

    @Override
    public boolean isDependentOnUserInput() {
        DeployTarget deployTarget = this.myTargetProvider.getCachedDeployTarget(DefaultRunExecutor.getRunExecutorInstance(), this.myAndroidFacet, this.myAndroidRunConfigurationBase.getDeviceCount(true), this.myAndroidRunConfigurationBase.getDeployTargetContext().getDeployTargetStates(), this.myAndroidRunConfigurationBase.getUniqueID());
        return deployTarget == null;
    }

    @Override
    @Nullable
    public Deployable getDeployable() {
        DeployTarget deployTarget = this.myTargetProvider.getCachedDeployTarget(DefaultRunExecutor.getRunExecutorInstance(), this.myAndroidFacet, this.myAndroidRunConfigurationBase.getDeviceCount(true), this.myAndroidRunConfigurationBase.getDeployTargetContext().getDeployTargetStates(), this.myAndroidRunConfigurationBase.getUniqueID());
        if (deployTarget == null) {
            return null;
        }
        DeployTargetState deployTargetState = this.myAndroidRunConfigurationBase.getDeployTargetContext().getDeployTargetState(this.myTargetProvider);
        DeviceFutures deviceFutures = deployTarget.getDevices(deployTargetState, this.myAndroidFacet, this.myAndroidRunConfigurationBase.getDeviceCount(true), true, this.myAndroidRunConfigurationBase.getUniqueID());
        if (deviceFutures == null) {
            return null;
        }
        try {
            String packageName = this.myAndroidRunConfigurationBase.getApplicationIdProvider(this.myAndroidFacet).getPackageName();
            List<AndroidDevice> devices = deviceFutures.getDevices();
            if (devices.isEmpty()) {
                return null;
            }
            return new ChooserDeployable(packageName, devices.get(0));
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }

    private static class ChooserDeployable
    implements Deployable {
        @NotNull
        private final String myPackageName;
        @NotNull
        private final AndroidDevice myAndroidDevice;

        private ChooserDeployable(@NotNull String packageName, @NotNull AndroidDevice androidDevice) {
            this.myPackageName = packageName;
            this.myAndroidDevice = androidDevice;
        }

        @Override
        @NotNull
        public Future<AndroidVersion> getVersion() {
            if (this.myAndroidDevice.isRunning()) {
                try {
                    return DeploymentApplicationService.getInstance().getVersion((IDevice)this.myAndroidDevice.getLaunchedDevice().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    return Futures.immediateFuture((Object)AndroidVersion.DEFAULT);
                }
            }
            return Futures.immediateFuture((Object)this.myAndroidDevice.getVersion());
        }

        @Override
        public boolean isApplicationRunningOnDeployable() {
            if (!this.myAndroidDevice.isRunning()) {
                return false;
            }
            try {
                IDevice device = (IDevice)this.myAndroidDevice.getLaunchedDevice().get(0L, TimeUnit.NANOSECONDS);
                if (device == null || !device.isOnline()) {
                    return false;
                }
                List<Client> clients = Deployable.searchClientsForPackage(device, this.myPackageName);
                return !clients.isEmpty();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return false;
            }
        }

        @Override
        public boolean isOnline() {
            if (!this.myAndroidDevice.isRunning()) {
                return false;
            }
            ListenableFuture<IDevice> iDeviceFuture = this.myAndroidDevice.getLaunchedDevice();
            if (!iDeviceFuture.isDone() || iDeviceFuture.isCancelled()) {
                return false;
            }
            try {
                return ((IDevice)iDeviceFuture.get()).isOnline();
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean isUnauthorized() {
            if (!this.myAndroidDevice.isRunning()) {
                return false;
            }
            ListenableFuture<IDevice> iDeviceFuture = this.myAndroidDevice.getLaunchedDevice();
            if (!iDeviceFuture.isDone() || iDeviceFuture.isCancelled()) {
                return false;
            }
            try {
                return ((IDevice)iDeviceFuture.get()).getState() == IDevice.DeviceState.UNAUTHORIZED;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

