/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.editor.DeepLinkConfigurable;
import com.android.tools.idea.run.editor.LaunchOption;
import com.android.tools.idea.run.editor.LaunchOptionConfigurable;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.LaunchOptionState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.AndroidDeepLinkLaunchTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepLinkLaunch
extends LaunchOption<State> {
    public static final DeepLinkLaunch INSTANCE = new DeepLinkLaunch();

    @Override
    @NotNull
    public String getId() {
        return "launch_deep_link";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "URL";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    @NotNull
    public LaunchOptionConfigurable<State> createConfigurable(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context) {
        return new DeepLinkConfigurable(project, context);
    }

    public static final class State
    extends LaunchOptionState {
        public String DEEP_LINK = "";

        @Override
        @Nullable
        public LaunchTask getLaunchTask(@NotNull String applicationId2, @NotNull AndroidFacet facet, @NotNull StartActivityFlagsProvider startActivityFlagsProvider, @NotNull ProfilerState profilerState) {
            return new AndroidDeepLinkLaunchTask(this.DEEP_LINK, startActivityFlagsProvider);
        }

        @Override
        @NotNull
        public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
            boolean isInstantApp;
            boolean bl = isInstantApp = ((AndroidFacetConfiguration)facet.getConfiguration()).getProjectType() == 4;
            if (this.DEEP_LINK == null || this.DEEP_LINK.isEmpty()) {
                if (isInstantApp) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)ValidationError.warning("URL not specified"));
            }
            if (isInstantApp) {
                boolean matched = false;
                List<Module> featureModules = InstantApps.findFeatureModules(facet);
                for (Module featureModule : featureModules) {
                    if (!new InstantAppUrlFinder(featureModule).matchesUrl(this.DEEP_LINK)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return ImmutableList.of((Object)ValidationError.warning("URL \"" + this.DEEP_LINK + "\" not defined in the manifest."));
                }
            }
            return ImmutableList.of();
        }
    }
}

