/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class DeployTargetContext
implements JDOMExternalizable {
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxVisible;
    private final Function<Boolean, Collection<DeployTargetProvider>> myGetDeployTargetProviders;
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        this(() -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get(), DeployTargetProvider::getProviders);
    }

    @VisibleForTesting
    DeployTargetContext(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxVisible, @NotNull Function<Boolean, Collection<DeployTargetProvider>> getDeployTargetProviders) {
        this.mySelectDeviceSnapshotComboBoxVisible = selectDeviceSnapshotComboBoxVisible;
        this.myGetDeployTargetProviders = getDeployTargetProviders;
        this.myDeployTargetStates = (Map)getDeployTargetProviders.apply(true).stream().collect(ImmutableMap.toImmutableMap(DeployTargetProvider::getId, DeployTargetProvider::createState));
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders(boolean testConfiguration) {
        boolean deviceSnapshotComboBoxVisible = this.mySelectDeviceSnapshotComboBoxVisible.get();
        return this.myGetDeployTargetProviders.apply(deviceSnapshotComboBoxVisible).stream().filter(provider -> provider.isApplicable(testConfiguration, deviceSnapshotComboBoxVisible)).collect(Collectors.toList());
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        String mode = this.getTargetSelectionMode().name();
        Optional<DeployTargetProvider> optionalProvider = this.myGetDeployTargetProviders.apply(this.mySelectDeviceSnapshotComboBoxVisible.get()).stream().filter(provider -> provider.getId().equals(mode)).findFirst();
        return optionalProvider.orElseThrow(AssertionError::new);
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        return this.myDeployTargetStates;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        return this.myDeployTargetStates.get(currentTarget.getId());
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        return this.myDeployTargetStates.get(target.getId());
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @VisibleForTesting
    void setTargetSelectionMode(@NotNull String mode) {
        this.TARGET_SELECTION_MODE = mode;
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        try {
            TargetSelectionMode mode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
            if (!this.mySelectDeviceSnapshotComboBoxVisible.get().booleanValue()) {
                switch (mode) {
                    case DEVICE_AND_SNAPSHOT_COMBO_BOX: {
                        return TargetSelectionMode.SHOW_DIALOG;
                    }
                    case SHOW_DIALOG: 
                    case EMULATOR: 
                    case USB_DEVICE: 
                    case FIREBASE_DEVICE_MATRIX: 
                    case FIREBASE_DEVICE_DEBUGGING: {
                        return mode;
                    }
                }
                throw new AssertionError((Object)mode);
            }
            switch (mode) {
                case DEVICE_AND_SNAPSHOT_COMBO_BOX: {
                    return mode;
                }
                case SHOW_DIALOG: 
                case EMULATOR: 
                case USB_DEVICE: {
                    return TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX;
                }
                case FIREBASE_DEVICE_MATRIX: 
                case FIREBASE_DEVICE_DEBUGGING: {
                    return mode;
                }
            }
            throw new AssertionError((Object)mode);
        }
        catch (IllegalArgumentException exception) {
            return this.mySelectDeviceSnapshotComboBoxVisible.get() != false ? TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX : TargetSelectionMode.SHOW_DIALOG;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }
}

