/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployTargetProvider<S extends DeployTargetState> {
    @VisibleForTesting
    static final ExtensionPointName<DeployTargetProvider> EP_NAME = ExtensionPointName.create((String)"com.android.run.deployTargetProvider");
    private static List<DeployTargetProvider> ourTargets;

    public static List<DeployTargetProvider> getProviders() {
        return DeployTargetProvider.getProviders((Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_VISIBLE.get());
    }

    @NotNull
    static List<DeployTargetProvider> getProviders(boolean deviceSnapshotComboBoxVisible) {
        if (ourTargets == null) {
            ourTargets = Arrays.asList(EP_NAME.getExtensions());
        }
        return DeployTargetProvider.filterOutDeviceAndSnapshotComboBoxProvider(ourTargets, deviceSnapshotComboBoxVisible);
    }

    @NotNull
    @VisibleForTesting
    static List<DeployTargetProvider> filterOutDeviceAndSnapshotComboBoxProvider(@NotNull List<DeployTargetProvider> providers, boolean selectDeviceSnapshotComboBoxVisible) {
        if (selectDeviceSnapshotComboBoxVisible) {
            return providers;
        }
        String deviceAndSnapshotComboBox = TargetSelectionMode.DEVICE_AND_SNAPSHOT_COMBO_BOX.name();
        return providers.stream().filter(provider -> !provider.getId().equals(deviceAndSnapshotComboBox)).collect(Collectors.toList());
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getDisplayName();

    @NotNull
    public abstract S createState();

    public boolean showInDevicePicker(@NotNull Executor executor) {
        return false;
    }

    protected boolean isApplicable(boolean testConfiguration, boolean deviceSnapshotComboBoxVisible) {
        return true;
    }

    public abstract DeployTargetConfigurable<S> createConfigurable(@NotNull Project var1, @NotNull Disposable var2, @NotNull DeployTargetConfigurableContext var3);

    public boolean requiresRuntimePrompt() {
        return false;
    }

    @Nullable
    public DeployTarget<S> showPrompt(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean androidTests, @NotNull Map<String, DeployTargetState> deployTargetStates, int runConfigId, @NotNull LaunchCompatibilityChecker compatibilityChecker) {
        throw new IllegalStateException();
    }

    public abstract DeployTarget<S> getDeployTarget();

    @NotNull
    public DeployTarget<S> getDeployTarget(@NotNull Project project) {
        return this.getDeployTarget();
    }

    public static class Renderer
    extends ColoredListCellRenderer<DeployTargetProvider> {
        protected void customizeCellRenderer(@NotNull JList list, DeployTargetProvider value2, int index, boolean selected, boolean hasFocus) {
            this.append(value2.getDisplayName());
        }
    }
}

