/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AccelerationErrorNotificationPanel;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceRenderer;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.DevicePickerListModel;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.editor.HelpHandler;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.AdbAssistantStats;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class DevicePicker
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
Disposable,
ActionListener,
ListSelectionListener {
    private static final int UPDATE_DELAY_MILLIS = 250;
    private static final String DEVICE_PICKER_LAST_SELECTION = "device.picker.selection";
    private static final TIntObjectHashMap<Set<String>> ourSelectionsPerConfig = new TIntObjectHashMap();
    private JPanel myPanel;
    private JButton myCreateEmulatorButton;
    private HyperlinkLabel myHelpHyperlink;
    private JScrollPane myScrollPane;
    private JPanel myNotificationPanel;
    private JBList<DevicePickerEntry> myDevicesList;
    private final AndroidDeviceRenderer myDeviceRenderer;
    private int myErrorGen;
    @NotNull
    private HelpHandler myHelpHandler;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myRunContextId;
    private DevicePickerListModel myModel;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    private final LaunchCompatibilityChecker myCompatibilityChecker;
    private final AtomicReference<List<AvdInfo>> myAvdInfos;

    public DevicePicker(@NotNull Disposable parent, int runContextId, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, @NotNull LaunchCompatibilityChecker compatibilityChecker, @NotNull HelpHandler helpHandler) {
        this.$$$setupUI$$$();
        this.myAvdInfos = new AtomicReference();
        this.myRunContextId = runContextId;
        this.myFacet = facet;
        this.myHelpHyperlink.addHyperlinkListener(e -> helpHandler.launchDiagnostics(AdbAssistantStats.Trigger.DONT_SEE_DEVICE));
        this.myCompatibilityChecker = compatibilityChecker;
        this.myHelpHandler = helpHandler;
        DeviceListSpeedSearch speedSearch = new DeviceListSpeedSearch(this.myDevicesList);
        this.myDeviceRenderer = new AndroidDeviceRenderer(this.myCompatibilityChecker, (SpeedSearchBase)speedSearch);
        this.setModel(new DevicePickerListModel());
        this.myDevicesList.setCellRenderer((ListCellRenderer)((Object)this.myDeviceRenderer));
        this.myDevicesList.setSelectionMode(DevicePicker.getListSelectionMode(deviceCount));
        this.myDevicesList.addKeyListener((KeyListener)new MyListKeyListener(speedSearch));
        this.myDevicesList.addListSelectionListener((ListSelectionListener)this);
        this.myNotificationPanel.setLayout(new BoxLayout(this.myNotificationPanel, 1));
        this.myCreateEmulatorButton.addActionListener(this);
        this.myUpdateQueue = new MergingUpdateQueue("android.device.chooser", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        this.myDevicesList = null;
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDevicesList;
    }

    private void createUIComponents() {
        this.myDevicesList = new JBList();
        this.myScrollPane = ScrollPaneFactory.createScrollPane(this.myDevicesList);
        this.myHelpHyperlink = new HyperlinkLabel("Don't see your device?");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myCreateEmulatorButton) {
            AvdOptionsModel avdOptionsModel = new AvdOptionsModel(null);
            ModelWizardDialog dialog2 = AvdWizardUtils.createAvdWizard((Component)this.myPanel, this.myFacet.getModule().getProject(), avdOptionsModel);
            if (dialog2.showAndGet()) {
                AvdInfo createdAvd = avdOptionsModel.getCreatedAvd();
                this.refreshAvds(createdAvd);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.myDevicesList) {
            Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValuesList());
            if (selectedSerials.isEmpty()) {
                return;
            }
            ourSelectionsPerConfig.put(this.myRunContextId, selectedSerials);
            DevicePicker.saveSelectionForProject(this.myFacet.getModule().getProject(), selectedSerials);
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        this.postUpdate();
    }

    public void deviceConnected(@NotNull IDevice device) {
        this.postUpdate();
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        this.postUpdate();
    }

    public void deviceChanged(IDevice device, int changeMask) {
        this.postUpdate();
    }

    public void refreshAvds(AvdInfo avdToSelect) {
        this.myDevicesList.setPaintBusy(true);
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.refreshAvdsNow(avdToSelect));
    }

    public void refreshAvdsNow(AvdInfo avdToSelect) {
        ImmutableList avdInfos = ImmutableList.copyOf(AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(true));
        DevicePicker.invokeLater(() -> this.lambda$refreshAvdsNow$2((List)avdInfos, avdToSelect));
    }

    private void updateErrorCheck() {
        List<AvdInfo> infos;
        ++this.myErrorGen;
        this.myNotificationPanel.removeAll();
        if (this.myModel.getNumberOfConnectedDevices() == 0) {
            EditorNotificationPanel panel2 = new EditorNotificationPanel();
            panel2.setText("No USB devices or running emulators detected");
            panel2.createActionLabel("Troubleshoot", () -> this.myHelpHandler.launchDiagnostics(AdbAssistantStats.Trigger.NO_RUNNING_DEVICE));
            this.myNotificationPanel.add((Component)panel2);
        }
        if ((infos = this.myAvdInfos.get()) != null && !infos.isEmpty()) {
            int currentErrorGen = this.myErrorGen;
            DevicePicker.executeOnPooledThread(() -> {
                AccelerationErrorCode error = AvdManagerConnection.getDefaultAvdManagerConnection().checkAcceleration();
                if (error != AccelerationErrorCode.ALREADY_INSTALLED) {
                    DevicePicker.invokeLater(() -> {
                        if (this.myErrorGen != currentErrorGen) {
                            return;
                        }
                        this.myNotificationPanel.add((Component)((Object)new AccelerationErrorNotificationPanel(error, this.myFacet.getModule().getProject(), this::updateErrorCheck)));
                    });
                }
            });
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    private static void executeOnPooledThread(Runnable runnable) {
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    private static void invokeLater(Runnable runnable) {
        EdtInvocationManager.getInstance().invokeLater(runnable);
    }

    private void postUpdate() {
        this.myUpdateQueue.queue(new Update("updateDevicePickerModel"){

            public void run() {
                DevicePicker.this.updateModel();
            }

            public boolean canEat(Update update2) {
                return true;
            }
        });
    }

    private void selectAvd(@NotNull AvdInfo avdToSelect) {
        String serial = new LaunchableAndroidDevice(avdToSelect).getSerial();
        List<DevicePickerEntry> items2 = this.myModel.getItems();
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            DevicePickerEntry entry = items2.get(i2);
            if (entry.isMarker()) continue;
            AndroidDevice device = entry.getAndroidDevice();
            assert (device != null) : "Non marker entry cannot be null";
            if (!serial.equals(device.getSerial())) continue;
            this.myDevicesList.setSelectedIndex(i2);
            return;
        }
    }

    private void updateModel() {
        this.updateModelAndSelectAvd(null);
    }

    private void updateModelAndSelectAvd(AvdInfo avdToSelect) {
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null || !bridge.isConnected()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            DevicePicker.invokeLater(() -> this.updateModelAndSelectAvd(avdToSelect));
            return;
        }
        if (this.myDevicesList == null) {
            return;
        }
        Set<String> selectedSerials = DevicePicker.getSelectedSerials(this.myDevicesList.getSelectedValuesList());
        this.myDevicesList.setPaintBusy(true);
        DevicePicker.executeOnPooledThread(() -> {
            List<IDevice> connectedDevices = Arrays.asList(bridge.getDevices());
            DevicePickerListModel initialModel = new DevicePickerListModel(connectedDevices, Collections.emptyList());
            DevicePicker.invokeLater(() -> {
                if (this.myDevicesList == null) {
                    return;
                }
                this.setModelAndSelectAvd(initialModel, avdToSelect, selectedSerials);
            });
            List<AvdInfo> infos = this.myAvdInfos.get();
            if (infos == null) {
                return;
            }
            DevicePickerListModel fullModel = new DevicePickerListModel(connectedDevices, infos);
            DevicePicker.invokeLater(() -> {
                if (this.myDevicesList == null) {
                    return;
                }
                this.setModelAndSelectAvd(fullModel, avdToSelect, selectedSerials);
                this.myHelpHyperlink.setVisible(this.myModel.getNumberOfConnectedDevices() == 0);
                this.updateErrorCheck();
                this.myDevicesList.setPaintBusy(false);
            });
        });
    }

    private void setModelAndSelectAvd(@NotNull DevicePickerListModel model2, AvdInfo avdToSelect, @NotNull Set<String> selectedSerials) {
        this.setModel(model2);
        if (avdToSelect != null) {
            this.selectAvd(avdToSelect);
        } else {
            int[] selectedIndices = DevicePicker.getIndices(this.myModel.getItems(), selectedSerials.isEmpty() ? this.getDefaultSelection() : selectedSerials);
            this.myDevicesList.setSelectedIndices(selectedIndices);
        }
    }

    private void setModel(@NotNull DevicePickerListModel model2) {
        this.myDeviceRenderer.clearCache();
        this.myModel = model2;
        this.myDevicesList.setModel((ListModel)this.myModel);
    }

    @NotNull
    private static int[] getIndices(@NotNull List<DevicePickerEntry> items2, @NotNull Set<String> selectedSerials) {
        TIntArrayList list = new TIntArrayList(selectedSerials.size());
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            DevicePickerEntry entry = items2.get(i2);
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "An entry in the device picker must be either a marker or an AndroidDevice, got null";
            if (!selectedSerials.contains(androidDevice.getSerial())) continue;
            list.add(i2);
        }
        return list.toNativeArray();
    }

    @NotNull
    private static Set<String> getSelectedSerials(@NotNull List<?> selectedValues) {
        HashSet<String> selection = new HashSet<String>();
        for (Object o : selectedValues) {
            AndroidDevice device;
            if (!(o instanceof DevicePickerEntry) || (device = ((DevicePickerEntry)o).getAndroidDevice()) == null) continue;
            selection.add(device.getSerial());
        }
        return selection;
    }

    @NotNull
    private Set<String> getDefaultSelection() {
        int[] indices;
        Set<String> lastSelection = (Set<String>)ourSelectionsPerConfig.get(this.myRunContextId);
        if (lastSelection == null || lastSelection.isEmpty()) {
            lastSelection = DevicePicker.getLastSelectionForProject(this.myFacet.getModule().getProject());
        }
        if (!lastSelection.isEmpty() && (indices = DevicePicker.getIndices(this.myModel.getItems(), lastSelection)).length > 0) {
            return lastSelection;
        }
        for (DevicePickerEntry entry : this.myModel.getItems()) {
            if (entry.isMarker()) continue;
            AndroidDevice androidDevice = entry.getAndroidDevice();
            assert (androidDevice != null) : "Non marker entry in the device picker doesn't contain an android device";
            if (this.myCompatibilityChecker.validate(androidDevice).isCompatible() == ThreeState.NO) continue;
            return ImmutableSet.of((Object)androidDevice.getSerial());
        }
        return Collections.emptySet();
    }

    private static int getListSelectionMode(@NotNull DeviceCount deviceCount) {
        return deviceCount.isMultiple() ? 2 : 0;
    }

    public ValidationInfo validate() {
        List<AndroidDevice> devices = this.getSelectedDevices();
        if (devices.isEmpty()) {
            return new ValidationInfo("No device selected", this.myDevicesList);
        }
        for (AndroidDevice device : devices) {
            LaunchCompatibility compatibility = this.myCompatibilityChecker.validate(device);
            if (compatibility.isCompatible() != ThreeState.NO) continue;
            String reason = StringUtil.notNullize((String)compatibility.getReason(), (String)"Incompatible");
            if (devices.size() > 1) {
                reason = device.getName() + ": " + reason;
            }
            return new ValidationInfo(reason, this.myDevicesList);
        }
        return null;
    }

    @NotNull
    public List<AndroidDevice> getSelectedDevices() {
        SmartList devices = new SmartList();
        for (DevicePickerEntry value2 : this.myDevicesList.getSelectedValuesList()) {
            AndroidDevice device = value2.getAndroidDevice();
            if (device == null) continue;
            devices.add((Object)device);
        }
        return devices;
    }

    public void installDoubleClickListener(@NotNull DoubleClickListener listener2) {
        new MyDoubleClickListener(listener2, this).installOn((Component)this.myDevicesList);
    }

    private static Set<String> getLastSelectionForProject(@NotNull Project project) {
        String s = PropertiesComponent.getInstance((Project)project).getValue(DEVICE_PICKER_LAST_SELECTION);
        return s == null ? Collections.emptySet() : ImmutableSet.copyOf((Object[])s.split(" "));
    }

    private static void saveSelectionForProject(@NotNull Project project, @NotNull Set<String> selectedSerials) {
        PropertiesComponent.getInstance((Project)project).setValue(DEVICE_PICKER_LAST_SELECTION, Joiner.on((char)' ').join(selectedSerials));
    }

    private /* synthetic */ void lambda$refreshAvdsNow$2(List avdInfos, AvdInfo avdToSelect) {
        if (this.myDevicesList == null) {
            return;
        }
        this.myAvdInfos.set(avdInfos);
        this.updateModelAndSelectAvd(avdToSelect);
        this.myDevicesList.setPaintBusy(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setPreferredSize(new Dimension(600, 400));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "South");
        this.myCreateEmulatorButton = jButton = new JButton();
        jButton.setText("Create New Virtual Device");
        jButton.setMnemonic('C');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        HyperlinkLabel hyperlinkLabel = this.myHelpHyperlink;
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 3, null, null, null));
        JScrollPane jScrollPane = this.myScrollPane;
        jPanel2.add((Component)jScrollPane, "Center");
        this.myNotificationPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "North");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class MyDoubleClickListener
    extends DoubleClickListener
    implements Disposable {
        private DoubleClickListener myDelegate;

        public MyDoubleClickListener(DoubleClickListener delegate, Disposable parent) {
            this.myDelegate = delegate;
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        protected boolean onDoubleClick(MouseEvent event) {
            return this.myDelegate != null && this.myDelegate.onClick(event, 2);
        }

        public void dispose() {
            this.myDelegate = null;
        }
    }

    private static class DeviceListSpeedSearch
    extends ListSpeedSearch<DevicePickerEntry> {
        public DeviceListSpeedSearch(JBList<DevicePickerEntry> list) {
            super(list);
        }

        protected String getElementText(Object element) {
            DevicePickerEntry entry;
            if (element instanceof DevicePickerEntry && !(entry = (DevicePickerEntry)element).isMarker()) {
                AndroidDevice device = entry.getAndroidDevice();
                assert (device != null) : "entry not a marker, yet device is null";
                return device.getName();
            }
            return "";
        }
    }

    private static class MyListKeyListener
    extends KeyAdapter {
        private final ListSpeedSearch mySpeedSearch;

        private MyListKeyListener(@NotNull ListSpeedSearch speedSearch) {
            this.mySpeedSearch = speedSearch;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.mySpeedSearch.isPopupActive()) {
                return;
            }
            JList list = (JList)e.getSource();
            if (MyListKeyListener.allListElementsMatch(list, x -> x.isMarker())) {
                return;
            }
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 40: {
                    ScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 34: {
                    ScrollingUtil.movePageDown((JList)list);
                    break;
                }
                case 38: {
                    ScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                    break;
                }
                case 33: {
                    ScrollingUtil.movePageUp((JList)list);
                    break;
                }
                default: {
                    return;
                }
            }
            DevicePickerEntry entry = (DevicePickerEntry)list.getSelectedValue();
            while (entry.isMarker()) {
                if (keyCode == 38 || keyCode == 33) {
                    ScrollingUtil.moveUp((JList)list, (int)e.getModifiersEx());
                } else {
                    ScrollingUtil.moveDown((JList)list, (int)e.getModifiersEx());
                }
                entry = (DevicePickerEntry)list.getSelectedValue();
            }
            e.consume();
        }

        private static <E> boolean allListElementsMatch(@NotNull JList<E> list, @NotNull Predicate<E> predicate) {
            for (int i2 = 0; i2 < list.getModel().getSize(); ++i2) {
                if (predicate.test(list.getModel().getElementAt(i2))) continue;
                return false;
            }
            return true;
        }
    }
}

