/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicFeaturesParameters {
    private static final int PREFERRED_HEIGHT_IN_ROWS = 4;
    @NotNull
    private final DynamicFeaturesTableModel myTableModel;
    @NotNull
    private final Set<String> myDisabledDynamicFeatures;
    private JPanel myRootPanel;
    private JBScrollPane myTableScrollPane;
    private JBTable myTable;
    private JBLabel myAdditionalTextLabel;

    public DynamicFeaturesParameters() {
        this.$$$setupUI$$$();
        this.myTableModel = new DynamicFeaturesTableModel();
        this.myDisabledDynamicFeatures = new HashSet<String>();
        this.myAdditionalTextLabel.setForeground(UIUtil.getInactiveTextColor());
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTable.setTableHeader(null);
        this.myTableScrollPane.setColumnHeaderView(null);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkMarkColumn = columnModel.getColumn(0);
        checkMarkColumn.setCellRenderer(new CheckBoxCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        columnModel.getColumn(1).setCellRenderer(new FeatureNameCellRenderer());
        this.disable();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootPanel;
    }

    JTable getTableComponent() {
        return this.myTable;
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        return ImmutableList.copyOf(this.myDisabledDynamicFeatures);
    }

    public void setActiveModule(@Nullable Module module, AvailableDeployTypes deployType) {
        this.setDisabledDynamicFeatures(new ArrayList<String>());
        if (module == null) {
            this.disable();
            return;
        }
        this.myTableModel.clear();
        this.addBaseModule(module);
        List<Module> features = DynamicAppUtils.getDependentFeatureModules(module);
        if (features.isEmpty()) {
            this.disable();
            return;
        }
        this.addFeatureList(features, deployType);
    }

    public void addFeatureList(@NotNull List<Module> features, AvailableDeployTypes deployType) {
        features.stream().sorted((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)).map(f -> this.createRow((Module)f, deployType)).forEach(row -> this.myTableModel.addRow((DynamicFeatureRow)row));
        this.enable();
    }

    @NotNull
    private DynamicFeatureRow createRow(@NotNull Module module, AvailableDeployTypes deployType) {
        if (deployType == AvailableDeployTypes.INSTANT_AND_INSTALLED) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 != null && model2.getSelectedVariant().isInstantAppCompatible()) {
                return new DynamicFeatureRow(module.getName(), this.isFeatureEnabled(module.getName()));
            }
            return new DynamicFeatureRow(module.getName(), this.isFeatureEnabled(module.getName()), true, FeatureType.NON_INSTANT_DYNAMIC_FEATURE);
        }
        return new DynamicFeatureRow(module.getName(), this.isFeatureEnabled(module.getName()));
    }

    public void addBaseModule(@NotNull Module module) {
        if (((Boolean)StudioFlags.UAB_ENABLE_NEW_INSTANT_APP_RUN_CONFIGURATIONS.get()).booleanValue()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) {
                return;
            }
            Module baseFeature = DynamicAppUtils.getBaseFeature(module);
            if (baseFeature != null || !model2.getAndroidProject().isBaseSplit()) {
                return;
            }
            baseFeature = module;
            this.myTableModel.addRow(new DynamicFeatureRow(baseFeature.getName(), true, false, FeatureType.BASE_FEATURE));
        }
    }

    public void setDisabledDynamicFeatures(@NotNull List<String> disabledDynamicFeatures) {
        this.myDisabledDynamicFeatures.clear();
        this.myDisabledDynamicFeatures.addAll(disabledDynamicFeatures);
        this.myTableModel.myFeatures.forEach(x -> {
            x.isChecked = this.isFeatureEnabled(x.getFeatureName());
        });
        this.myTableModel.fireTableDataChanged();
    }

    public void updateBasedOnInstantState(@NotNull Module module, boolean instantAppDeploy) {
        List<Module> features = DynamicAppUtils.getDependentInstantFeatureModules(module);
        List featurenames = features.stream().map(x -> x.getName()).collect(Collectors.toList());
        if (instantAppDeploy) {
            this.myTableModel.myFeatures.forEach(x -> {
                if (!featurenames.contains(x.getFeatureName()) && !x.isBaseFeature()) {
                    x.isChecked = false;
                    x.setEnabled(false);
                    this.myDisabledDynamicFeatures.add(x.getFeatureName());
                }
            });
        } else {
            this.myTableModel.myFeatures.forEach(x -> {
                if (!x.isBaseFeature()) {
                    x.setEnabled(true);
                }
            });
        }
        this.myTableModel.fireTableDataChanged();
    }

    private boolean isFeatureEnabled(@NotNull String name) {
        return !this.myDisabledDynamicFeatures.contains(name);
    }

    private void enable() {
        this.myTableModel.fireTableDataChanged();
        Insets insets = this.myTableScrollPane.getInsets();
        int minHeight = insets.top + this.myTable.getRowHeight() * 4 + insets.bottom;
        this.myTableScrollPane.setMinimumSize(new Dimension(200, minHeight));
        this.myRootPanel.setVisible(true);
    }

    private void disable() {
        this.myTableModel.clear();
        this.myTableModel.fireTableDataChanged();
        this.myRootPanel.setVisible(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JBScrollPane jBScrollPane;
        JBLabel jBLabel;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, "North");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0), null, 0, 0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Dynamic features to deploy:");
        jPanel2.add((Component)jBLabel2, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0), null, 0, 0, null, null));
        this.myAdditionalTextLabel = jBLabel = new JBLabel();
        jBLabel.setText("(for devices that support dynamic features)");
        jPanel3.add((Component)jBLabel, "Center");
        this.myTableScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.myTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class CheckBoxCellRenderer
    extends StripedRowCellRenderer {
        private final TableCellRenderer myDelegate;

        public CheckBoxCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            DynamicFeatureRow featureRow = (DynamicFeatureRow)DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row);
            component.setEnabled(featureRow.isEnabled);
            return component;
        }
    }

    @VisibleForTesting
    class FeatureNameCellRenderer
    extends StripedRowCellRenderer {
        FeatureNameCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table2.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            DynamicFeatureRow featureRow = (DynamicFeatureRow)DynamicFeaturesParameters.this.myTableModel.myFeatures.get(row);
            this.setText(featureRow.getDisplayName());
            component.setEnabled(isSelected || featureRow.isEnabled);
            return component;
        }
    }

    private static class StripedRowCellRenderer
    extends DefaultTableCellRenderer {
        private StripedRowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (!isSelected) {
                component.setBackground(row % 2 == 0 ? UIUtil.getDecoratedRowColor() : UIUtil.getTableBackground());
            }
            return component;
        }
    }

    private class DynamicFeaturesTableModel
    extends AbstractTableModel {
        public static final int CHECK_MARK_COLUMN_INDEX = 0;
        public static final int FEATURE_NAME_COLUMN_INDEX = 1;
        private List<DynamicFeatureRow> myFeatures = new ArrayList<DynamicFeatureRow>();

        public void clear() {
            this.myFeatures.clear();
        }

        public void addRow(@NotNull DynamicFeatureRow row) {
            this.myFeatures.add(row);
        }

        @Override
        public int getRowCount() {
            return this.myFeatures.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.myFeatures.get((int)rowIndex).isChecked;
            }
            if (columnIndex == 1) {
                return this.myFeatures.get(rowIndex).getFeatureName();
            }
            return null;
        }

        @Override
        public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
            DynamicFeatureRow row = this.myFeatures.get(rowIndex);
            if (columnIndex == 0) {
                boolean bl = row.isChecked = aValue == null || (Boolean)aValue != false;
                if (row.isChecked) {
                    DynamicFeaturesParameters.this.myDisabledDynamicFeatures.remove(row.getFeatureName());
                } else {
                    DynamicFeaturesParameters.this.myDisabledDynamicFeatures.add(row.getFeatureName());
                }
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @NotNull
        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 && this.myFeatures.get((int)rowIndex).isEnabled;
        }
    }

    private static class DynamicFeatureRow {
        @NotNull
        private final String featureName;
        public boolean isChecked;
        public boolean isEnabled;
        public FeatureType featureType;

        public DynamicFeatureRow(@NotNull String name, boolean isChecked, boolean isEnabled, FeatureType featureType) {
            this.featureName = name;
            this.isChecked = isChecked;
            this.isEnabled = isEnabled;
            this.featureType = featureType;
        }

        public DynamicFeatureRow(@NotNull String name, boolean isChecked) {
            this(name, isChecked, true, FeatureType.DYNAMIC_FEATURE);
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public String getDisplayName() {
            if (this.featureType == FeatureType.BASE_FEATURE) {
                return this.featureName + " (base)";
            }
            if (this.featureType == FeatureType.NON_INSTANT_DYNAMIC_FEATURE) {
                return this.featureName + " (not instant app enabled)";
            }
            return this.featureName;
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public boolean isBaseFeature() {
            return this.featureType == FeatureType.BASE_FEATURE;
        }
    }

    public static enum FeatureType {
        BASE_FEATURE,
        NON_INSTANT_DYNAMIC_FEATURE,
        DYNAMIC_FEATURE;

    }

    public static enum AvailableDeployTypes {
        INSTALLED_ONLY,
        INSTANT_AND_INSTALLED;

    }
}

